<?php

/**
 * Elementor Single Widget
 * @package fladient Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Fladient_Blog extends Widget_Base {



	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fladient-post-grid';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Fladient Blog Post', 'fladient-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fladient-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fladient_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'int_layout_opt',
			[
				'label' => esc_html__( 'Blog Layout Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'fladient-plugin' ),
					'2'  => esc_html__( 'Style 2', 'fladient-plugin' ),
				]
			]
		);
		$this->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Type your description here', 'fladient-plugin' ),
				'condition' => [
					'style' => ['2', '4', '5'],
				],
			]
		);

        	
		$this->end_controls_section();

        $this->start_controls_section(
			'post_sec_h_option',
			[
				'label' => esc_html__( 'Post Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'fladient-plugin' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'fladient-plugin' ),
					'DESC' => esc_html__( 'Descending', 'fladient-plugin' ),
				],
			]
		);
		
		$this->add_control(
			'post_per_page',
			[
				'label'   => __( 'Posts Per Page', 'fladient-plugin' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5,
			]
		);
        $this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'fladient-plugin' ),
				'options'     => Fladient_Blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
		$this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'fladient-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label'     => __( 'Excerpt Length', 'fladient-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
        $this->add_control(
			'button_label', [
				'label' => esc_html__( 'Readmore Button', 'fladient-plugin' ),
				'default' => esc_html__( 'Read more', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
			]
		);
        $this->add_control(
			'button_img', [
				'label' => esc_html__( 'Button Img', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'condition' => [
					'style' => ['5'],
				],
			]
		);
		

		$this->end_controls_section();
        $this->start_controls_section(
			'blog_style',
			[
				'label' => esc_html__( 'Blog Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_control(
			'post_title',
			[
				'label' => esc_html__( 'Post Title Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'post_list_title_color',
			[
				'label' => esc_html__( 'Post Title Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-title' => 'color: {{VALUE}}'
				],
			]
		);
        $this->add_control(
			'post_hover_title_color',
			[
				'label' => esc_html__( 'Post Title Hover Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-title:hover' => 'color: {{VALUE}}'
				],
			]
		);
       
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_title_typography',
				'selector' => '
					{{WRAPPER}} .item-title
				',
			]
		);
        
        $this->add_control(
			'post_date_title',
			[
				'label' => esc_html__( 'Post Date Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
			'post_date_color',
			[
				'label' => esc_html__( 'Post Date Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-date' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'post_date_bg_color',
			[
				'label' => esc_html__( 'Post Date BG Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-date' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_date_typography',
				'selector' => '
					{{WRAPPER}} .item-date
				',
			]
		);
		
        $this->add_control(
			'post_desc_title',
			[
				'label' => esc_html__( 'Post Description Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'post_desc_color',
			[
				'label' => esc_html__( 'Post Description Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-disc' => 'color: {{VALUE}}'
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_desc_typography',
				'selector' => '
				{{WRAPPER}} .item-disc
				',
			]
		);
		
		$this->end_controls_section();
		 // feature style
		 $this->start_controls_section(
			'slider_button_one',
			[
				'label' => esc_html__( 'Button Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'm_b_typography',
				'selector' => '
				{{WRAPPER}} .ftc-btn-1,
				{{WRAPPER}} .ftc-blog-3-item .item-btn
				',
			]
		);
        $this->add_control(
			'padding',
			[
				'label' => esc_html__( 'Padding', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ftc-btn-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'b_round',
			[
				'label' => esc_html__( 'Border Radius', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ftc-btn-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


        $this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'fladient-plugin' ),
			]
		);
        $this->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Text Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftc-btn-1' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_color',
				'types' => [ 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .ftc-btn-1',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Button BG Color ', 'fladient-plugin' ),
                        'description' => esc_html__( 'Choose background type and style.', 'fladient-plugin' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);
        $this->end_controls_tab();
        $this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'fladient-plugin' ),
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_hover_color',
				'types' => [ 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '
					{{WRAPPER}} .ftc-btn-1:before,
					{{WRAPPER}} .ftc-blog-3-item .item-btn::after
				',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Button Hover BG Color ', 'fladient-plugin' ),
                        'description' => esc_html__( 'Choose background type and style.', 'fladient-plugin' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);
        $this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	

        $args = array(
			'post_type'           => 'post',
			'posts_per_page'      => !empty( $settings['post_per_page'] ) ? $settings['post_per_page'] : 1,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'order'               => $settings['post_order'],
		);
		if( ! empty($settings['post_categories'] ) ){
			$args['category_name'] = implode(',', $settings['post_categories']);
		}
		
		$query = new \WP_Query( $args );
        require __DIR__ . '/view/blog/blog-' . $settings['style'] . '.php';
    }
    protected function fladient_category_name(){
        $catgorys = get_the_category();
    
        // Shuffle the array of categories
        shuffle($catgorys);
    
        // Select a random category
        $random_category = array_rand($catgorys, 1);
        $category = $catgorys[$random_category];
    
        $meta = get_term_meta($category->term_id, 'barfii_cate_meta', true);
        $catemeta = !empty( $meta['cate-color'] )? $meta['cate-color'] : '#3b60fe';
        ?>
        <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>">
            <span><?php echo esc_html($category->cat_name); ?></span> 
        </a>
    <?php
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Fladient_Blog() );