<?php

/**
 * Elementor Single Widget
 * @package fladient Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Fladient_Feature_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-feature-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Feature Slider', 'fladient-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fladient-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fladient_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Style Select', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'fladient-plugin' )
				]
			]
		);
        $this->end_controls_section();
        
        $this->start_controls_section(
			'--fs-slider-option',
			[
				'label' => esc_html__( 'Feature Slider Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $repeater = new \Elementor\Repeater();
        
        
        $repeater->add_control(
            'type',
            [
                'label'          => __( 'Icon Type', 'gesto-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'image' => [
                        'title' => __( 'Image', 'gesto-core' ),
                        'icon'  => 'eicon-image',
                    ],
                    'video' => [
                        'title' => __( 'Video', 'gesto-core' ),
                        'icon'  => 'eicon-slider-video',
                    ],
                ],
                'default'        => 'image',
                'toggle'         => false,
                'style_transfer' => true,
                
            ]
        );
        
        $repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'      => [
                    'type' => 'image',
                ],
			]
		);
        $repeater->add_control(
			'video', [
				'label' => esc_html__( 'Video', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'media_types' => [ 'video' ],
                'condition'      => [
                    'type' => 'video',
                ],
			]
		);
       
        $this->add_control(
			'features',
			[
				'label' => esc_html__( 'Add Feature Slide', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'slider_setting',
			[
				'label' => esc_html__( 'Slider Setting Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'sub_title_show',
			[
				'label' => esc_html__( 'Show Sub Title', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fladient-plugin' ),
				'label_off' => esc_html__( 'Hide', 'fladient-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        
        $this->add_control(
			'title_show',
			[
				'label' => esc_html__( 'Title SHow', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fladient-plugin' ),
				'label_off' => esc_html__( 'Hide', 'fladient-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
       
		$this->end_controls_section();

		// Sub title style
		$this->start_controls_section(
			'icon_style',
			[
				'label' => esc_html__( 'Icon Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'sub_margin',
			[
				'label' => esc_html__( 'List Icon Margin', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ftc-campaign-2-feature .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftc-campaign-2-feature .icon' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'icon-size',
			[
				'label' => esc_html__( 'Icon Size', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ftc-campaign-2-feature .icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		
		$this->start_controls_section(
			'slider_sub_title_style',
			[
				'label' => esc_html__( 'Title Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'ttl_margin',
			[
				'label' => esc_html__( 'Title Margin', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ftc-campaign-2-feature' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Sub Title Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftc-campaign-2-feature' => 'color: {{VALUE}}',
				],
			]
		);
		// typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'm_s_typography',
				'selector' => '{{WRAPPER}} .ftc-campaign-2-feature',
			]
		);

		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/feature-slider/slide-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Fladient_Feature_Slider() );