<?php

/**
 * Elementor Single Widget
 * @package fladient Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Fladient_Header_Five extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fladient-header-five';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Fladient Header Five', 'fladient-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fladient-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fladient_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'logoop',
			[
				'label' => esc_html__( 'Logo Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
       
		$this->add_control(
			'logoop_light', [
				'label' => esc_html__( 'Logo Light', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
			]
		);
		$this->add_control(
			'rzlogo', [
				'label' => esc_html__( 'Logo', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
			]
		);
		
		$this->add_responsive_control(
			'logo_max_width',
			[
				'label' => esc_html__( 'Max Width', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5000,
					]
				],

				'selectors' => [
					'{{WRAPPER}} .logo_site-size' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
		$this->end_controls_section();

        $this->start_controls_section(
			'menu_select',
			[
				'label' => esc_html__( 'Menu Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

        $this->add_control(
			'menus',
			[
				'label' => esc_html__( 'Add Menu Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
			]
		);
        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
			'tits_id', [
				'label' => esc_html__( 'Section ID', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $this->add_control(
			'sections',
			[
				'label' => esc_html__( 'Add Section Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'mobile_menu_opt',
			[
				'label' => esc_html__( 'Mobile Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'mrzlogo', [
				'label' => esc_html__( 'Mobile Logo', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
			]
		);
		$this->add_responsive_control(
			'logo_max_m_width',
			[
				'label' => esc_html__( 'Max Width', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5000,
					]
				],

				'selectors' => [
					'{{WRAPPER}} .logo img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'shortdesc', [
				'label' => esc_html__( 'Short Description', 'fladient-plugin' ),
				'default' => esc_html__( 'premium wordpress theme for portfolio, freelancer, design agencies and a wide range of other design institutions', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'fladient-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

        $this->add_control(
			'infos',
			[
				'label' => esc_html__( 'Add Info Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);

		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'fladient-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'name', [
				'label' => esc_html__( 'Title', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'socials',
			[
				'label' => esc_html__( 'Add Social Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'default' => [
					[
						'icons' => [
							'value'   => 'fab fa-facebook-f',
                    		'library' => 'solid',
						],
						'name' => esc_html__( 'Facebook', 'fladient-plugin' ),
						'link' => esc_html__( 'https://facebook.com', 'fladient-plugin' ),
					],
					[
						'icons' => [
							'value'   => 'fab fa-instagram',
                    		'library' => 'solid',
						],
						'name' => esc_html__( 'Instagram', 'fladient-plugin' ),
						'link' => esc_html__( 'https://instagram.com', 'fladient-plugin' ),
					],
					[
						'icons' => [
							'value'   => 'fab fa-youtube',
                    		'library' => 'solid',
						],
						'name' => esc_html__( 'Youtube', 'fladient-plugin' ),
						'link' => esc_html__( 'https://youtube.com', 'fladient-plugin' ),
					],
					[
						'icons' => [
							'value'   => 'fab fa-linkedin',
                    		'library' => 'solid',
						],
						'name' => esc_html__( 'Linkedin', 'fladient-plugin' ),
						'link' => esc_html__( 'https://linkedin.com', 'fladient-plugin' ),
					]
				],
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);
		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings );
		if ( ! empty( $settings['btn_link']['url'] ) ) {
			$this->add_link_attributes( 'btn_link', $settings['btn_link'] );
		}
		fladient_preloader();
		?>
        <script>
            jQuery(window).load(function() {
                if(jQuery('#pagepiling').length) {
                    if (window.innerWidth >= 1200 ) {
                        jQuery('#pagepiling').pagepiling({
                    
                            menu: '#onePageMenu',
                    
                            anchors: [<?php foreach($settings['sections'] as $item):?> '<?php echo strtolower($item['tits_id'])?>',<?php endforeach;?> ],
                            navigation: false,
                    
                            afterRender: function () {
                                jQuery('#pp-nav').addClass('custom');
                                pageScrollIndecator();
                            },
                    
                            onLeave: function () {
                                pageScrollIndecator();
                            },
                    
                            afterLoad: function (anchorLink, index) {
                                if (index > 1) {
                                    jQuery('#pp-nav').removeClass('custom');
                                } else {
                                    jQuery('#pp-nav').addClass('custom');
                                }
                    
                            }
                    
                        });
                    
                        function pageScrollIndecator() {
                            var allSection = jQuery('#pagepiling .section');
                            var sectionCount = parseInt(allSection.length);
                    
                            var activeSection = jQuery('#pagepiling').children('.section.active');
                            var activeCount = allSection.index(activeSection);
                    
                            var activeIndex = parseInt(activeCount) + 1;
                            var scale = (activeIndex / sectionCount).toFixed(3);
                    
                            jQuery('.pagescroll-indication span').css({
                                'transform': 'scaleY(' + scale + ')'
                            });
                        }
                    }
                }
            });
        </script>
        <div class="fd-header-5-area  ">


            <!-- header-main -->
            <div class="fd-header-1-main">
                <div class="fd-header-1-container">
                    <div class="fd-header-1-main-row d-flex align-items-center justify-content-between">

                        <a href="<?php echo esc_url(home_url());?>" aria-label="name" class="fd-header-5-main-logo d-block p-relative">
                            <?php if(!empty($settings['rzlogo']['url'])):?>
                                <img class="logo-1" src="<?php echo esc_url($settings['rzlogo']['url']);?>" alt="<?php echo esc_attr($settings['rzlogo']['alt']);?>">
                            <?php endif;?>
                            <?php if(!empty($settings['logoop_light']['url'])):?>
                                <img class="logo-2" src="<?php echo esc_url($settings['logoop_light']['url']);?>" alt="">
                            <?php endif;?>
                        </a>

                        <!-- menu -->
                        <nav class="main-navigation d-none d-lg-block">
                            <ul id="main-nav" class="nav navbar-nav clearfix">
                                <?php foreach($settings['menus'] as $item):?>
                                    <li data-menuanchor="<?php echo esc_url($item['link']['url']);?>">
                                        <a href="<?php echo esc_url($item['link']['url']);?>"><?php echo fladient_wp_kses($item['title'])?></a>
                                    </li>
                                <?php endforeach;?> 
                            </ul>
                        </nav>

                        <div class="fd-header-5-action-link d-flex align-items-center justify-content-end">

                            <!-- fd-search-btn -->
                            <button class="fd-search-btn-1 search_btn_toggle" type="button" aria-label="name">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                            
                            <!-- fd-cart-btn -->
                            <a href="#" class="fd-cart-btn-1 " aria-label="name">
                                <i class="fa-regular fa-cart-shopping"></i>
                            </a>

                            <!-- fd-user-btn -->
                            <a href="#" aria-label="name" class="fd-user-btn">
                                <i class="fa-regular fa-user"></i>
                            </a>

                            <!-- sidebar-btn -->
                            <button type="button" aria-label="name" class="fd-mobile-menu-btn-1 open_menu" id="menuToggle">
                                <span></span>
                                <span></span>
                                <span></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            </div>
			
        <?php
		echo $this->___search_body();
		echo $this->__mobile_menu();
    }

	/**
	 * Search Body Display
	 *
	 * @return void
	 */
	protected function ___search_body(){
		$settings = $this->get_settings_for_display();
		?>
		<div class="popup-search-box search_1_popup_active ">
			<button aria-label="search" type="button" class="popup-search-box-close search_1_popup_close">
				<i class="fa-solid fa-xmark"></i>
			</button>

			<div class="container popup-search-box-container">

				<?php if(!empty($settings['search_title'])):?>
					<h4 class="title kd-heading-1 ftc-font-700 t text-capitalize"><?php echo esc_html($settings['search_title']);?></h4>
				<?php endif;?>

				<div class="popup-search-box-form">
					<form action="<?php echo esc_url(home_url( '/' ));?>">
						<div class="popup-search-box-input">

							<input class="search-input" required type="search" name="s" aria-label="search" placeholder="<?php esc_attr_e( 'Search Keywords..', 'fladient-plugin' );?>" value="<?php print esc_attr( get_search_query() )?>">
						</div>
						<button aria-label="search" type="submit"><i class="fal fa-search"></i></button>
					</form>
				</div>
			</div>
		</div>
<?php 
	}



	/**
	 * Mobile Menu Display
	 *
	 * @return void
	 */
	protected function __mobile_menu(){ 
		$settings = $this->get_settings_for_display();
	?>
	<div class="mobile-menu lenis lenis-smooth" >
		<div class="mobile-menu-wrap">

			
			<div class="mobile-menu-logo-wrap mb-40">
				<a href="<?php echo esc_url(home_url( '/' ));?>" class="mobile-menu-logo d-block" aria-label="brand-logo"  >
					<img src="<?php echo esc_url($settings['mrzlogo']['url']);?>" alt="<?php if(!empty($settings['mrzlogo']['alt'])){ echo esc_attr($settings['mrzlogo']['alt']);}else{esc_attr_e('Shape', 'gtbus-plugin');}?>">
				</a>
				<div class="mobile-menu-close open_menu" id="menuToggle2">
					<i class="fa-solid fa-xmark"></i>
				</div>
			</div>
			<?php if(!empty($settings['shortdesc'])):?>
				<p class="fd-para-2 mobile-menu-disc"><?php echo fladient_wp_kses($settings['shortdesc']);?></p>
			<?php endif;?>

			<!-- search-form -->
			<div class="mobile-menu-search-bar">
				<form action="<?php echo esc_url(home_url( '/' ));?>" class="mobile-menu-search-form-1 mb-50" >
					<input type="text" name="search" placeholder="<?php esc_attr_e( 'Search', 'gtbus-plugin' );?>" value="<?php echo get_search_query();?>">
					<button class="form-btn" type="button" aria-label="name" >
						<i class="fa-solid fa-magnifying-glass"></i>
					</button>

				</form>
			</div>

			<!-- mobile-menu-list -->
			<div class="mobile-menu-navigation">
				<nav class="mobile-main-navigation  clearfix ul-li">
					<?php
						echo str_replace(['menu-item-has-children', 'sub-menu'], ['dropdown', 'dropdown-menu clearfix'], wp_nav_menu( array(
							'echo'           => false,
							'menu' => !empty($settings['choose-menu']) ? $settings['choose-menu'] : 'menu-1',
							'menu_id'        =>'main-nav',
							'menu_class'        =>'nav navbar-nav clearfix',
							'container'=>false,
							'fallback_cb'    => 'Navwalker_Class::fallback',
							'walker'         => class_exists( 'Rs_Mega_Menu_Walker' ) ? new \Rs_Mega_Menu_Walker : '',
						)) );
					?>
				</nav>
			</div>

			<!-- social-link -->
			<div class="mobile-menu-social-1 ">
				<?php foreach($settings['socials'] as $item):?>
					<a href="<?php echo esc_url($item['link']['url']);?>" aria-label="name" data-toggle="tooltip" data-placement="bottom" title="<?php echo esc_attr($item['name']);?>">
						<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</a>
				<?php endforeach;?>
			</div>


		</div>

		<div class="mobile_menu_overlay open_menu"></div>
	</div>
	<?php }


}


Plugin::instance()->widgets_manager->register( new Fladient_Header_Five() );