<?php

/**
 * Elementor Single Widget
 * @package fladient Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Fladient_Header extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fladient-header';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Fladient Header', 'fladient-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fladient-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fladient_widgets' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'thx_header_layout',
			[
				'label' => esc_html__( 'Header Layout', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Header 1', 'fladient-plugin' ),
					'2'  => esc_html__( 'Header 2', 'fladient-plugin' ),
					'3'  => esc_html__( 'Header 3', 'fladient-plugin' ),
					'4'  => esc_html__( 'Header 4', 'fladient-plugin' ),
					'5'  => esc_html__( 'Header 5', 'fladient-plugin' )
				]
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'menu_btn_select',
			[
				'label' => esc_html__( 'Header General Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'header_cart_hide',
			[
				'label' => esc_html__( 'Cart HIDE/SHOW', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fladient-plugin' ),
				'label_off' => esc_html__( 'Hide', 'fladient-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'style' => ['1', '2', '3', '4'],
				],
			]
		);
		$this->add_control(
			'header_lang_hide',
			[
				'label' => esc_html__( 'Languages HIDE/SHOW', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fladient-plugin' ),
				'label_off' => esc_html__( 'Hide', 'fladient-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'style' => ['1', '3'],
				],
			]
		);
		$this->add_control(
			'languages', [
				'label' => esc_html__( 'Languages', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'condition' => [
					'header_lang_hide' => 'yes',
					'style' => ['1', '3'],
				],
			]
		);
		$this->add_control(
			'ac_languages', [
				'label' => esc_html__( 'Active Languages', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'condition' => [
					'header_lang_hide' => 'yes',
					'style' => ['1', '3'],
				],
			]
		);
		$this->add_control(
			'sear_hide_show',
			[
				'label' => esc_html__( 'Search HIDE/SHOW', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fladient-plugin' ),
				'label_off' => esc_html__( 'Hide', 'fladient-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'style' => ['1', '3'],
				],
			]
		);
		
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Header Button Label', 'fladient-plugin' ),
				'default' => esc_html__( 'Let’s Talk', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'condition' => [
					'style' => ['1', '2', '3', '4'],
				],
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Header Button Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
				'condition' => [
					'style' => ['1', '2', '3', '4'],
				],
			]
		);
		$this->add_control(
			'top_bg', [
				'label' => esc_html__( 'Header Top BG Image', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'condition' => [
					'style' => ['1'],
				],
			]
		);
		$this->add_control(
			'top_text', [
				'label' => esc_html__( 'Header Top Text', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'condition' => [
					'style' => ['1'],
				],
			]
		);
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'icons', [
				'label' => esc_html__( 'Icon', 'fladient-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

        $this->add_control(
			'socialss',
			[
				'label' => esc_html__( 'Add Social Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'condition' => [
					'style' => ['2', '4'],
				],
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'logoop',
			[
				'label' => esc_html__( 'Logo Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'rzlogo', [
				'label' => esc_html__( 'Logo', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
			]
		);
		
		$this->add_responsive_control(
			'logo_max_width',
			[
				'label' => esc_html__( 'Max Width', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5000,
					]
				],

				'selectors' => [
					'{{WRAPPER}} .logo_site-size' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
		$this->end_controls_section();

        $this->start_controls_section(
			'menu_select',
			[
				'label' => esc_html__( 'Menu Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'choose-menu',
			[
				'label' => esc_html__( 'Choose menu', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => fladient_menu_selector(),
				'multiple' => false
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'mobile_menu_opt',
			[
				'label' => esc_html__( 'Mobile Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'mrzlogo', [
				'label' => esc_html__( 'Mobile Logo', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
			]
		);
		$this->add_responsive_control(
			'logo_max_m_width',
			[
				'label' => esc_html__( 'Max Width', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5000,
					]
				],

				'selectors' => [
					'{{WRAPPER}} .logo img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'shortdesc', [
				'label' => esc_html__( 'Short Description', 'fladient-plugin' ),
				'default' => esc_html__( 'premium wordpress theme for portfolio, freelancer, design agencies and a wide range of other design institutions', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'fladient-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

        $this->add_control(
			'infos',
			[
				'label' => esc_html__( 'Add Info Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);

		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'fladient-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'name', [
				'label' => esc_html__( 'Title', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'socials',
			[
				'label' => esc_html__( 'Add Social Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'default' => [
					[
						'icons' => [
							'value'   => 'fab fa-facebook-f',
                    		'library' => 'solid',
						],
						'name' => esc_html__( 'Facebook', 'fladient-plugin' ),
						'link' => esc_html__( 'https://facebook.com', 'fladient-plugin' ),
					],
					[
						'icons' => [
							'value'   => 'fab fa-instagram',
                    		'library' => 'solid',
						],
						'name' => esc_html__( 'Instagram', 'fladient-plugin' ),
						'link' => esc_html__( 'https://instagram.com', 'fladient-plugin' ),
					],
					[
						'icons' => [
							'value'   => 'fab fa-youtube',
                    		'library' => 'solid',
						],
						'name' => esc_html__( 'Youtube', 'fladient-plugin' ),
						'link' => esc_html__( 'https://youtube.com', 'fladient-plugin' ),
					],
					[
						'icons' => [
							'value'   => 'fab fa-linkedin',
                    		'library' => 'solid',
						],
						'name' => esc_html__( 'Linkedin', 'fladient-plugin' ),
						'link' => esc_html__( 'https://linkedin.com', 'fladient-plugin' ),
					]
				],
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'menu_bar_style',
			[
				'label' => esc_html__( 'Menu  Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'--menu--style-info',
			[
				'label' => esc_html__( 'Menu Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
        $this->add_control(
			'menu_color',
			[
				'label' => esc_html__( 'Menu Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-navigation .navbar-nav li a' => 'color: {{VALUE}}'
				],
			]
		);
        $this->add_control(
			'menu_color-hover',
			[
				'label' => esc_html__( 'Menu Hover Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-navigation .navbar-nav li:hover > a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .main-navigation .navbar-nav li a::after' => 'background-color: {{VALUE}}'
				],
			]
		);
		
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_fb_typography',
				'selector' => '
					{{WRAPPER}} .main-navigation .navbar-nav li a
				',
			]
		);
		$this->add_control(
			'menu_dropdown_style',
			[
				'label' => esc_html__( 'Menu Dropdown Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
        $this->add_control(
			'mdb_color',
			[
				'label' => esc_html__( 'Dropdown Box BG Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-navigation .navbar-nav li .dropdown-menu' => 'background: {{VALUE}}'
				],
			]
		);
        $this->add_control(
			'mdb_menu_color',
			[
				'label' => esc_html__( 'Dropdown Box Border Color', 'fladient-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-navigation .navbar-nav li .dropdown-menu' => 'border-color: {{VALUE}}'
				],
			]
		);
		
        $this->end_controls_section();
			// feature style
			$this->start_controls_section(
				'--button_one',
				[
					'label' => esc_html__( 'Button Style', 'goyto-plugin' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'm_b_typography',
					'selector' => '
					{{WRAPPER}} .fd-pr-btn-1
					',
				]
			);
			$this->add_control(
				'padding',
				[
					'label' => esc_html__( 'Padding', 'goyto-plugin' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .fd-pr-btn-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->add_control(
				'b_round',
				[
					'label' => esc_html__( 'Border Radius', 'goyto-plugin' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .fd-pr-btn-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
	
	
			$this->start_controls_tabs(
				'style_tabs'
			);
	
			$this->start_controls_tab(
				'style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'goyto-plugin' ),
				]
			);
			$this->add_control(
				'btn_text',
				[
					'label' => esc_html__( 'Text Color', 'goyto-plugin' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fd-pr-btn-1' => 'color: {{VALUE}}'
					],
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'button_bg_color',
					'types' => [ 'gradient' ],
					'exclude' => [ 'image' ],
					'selector' => '
					{{WRAPPER}} .fd-pr-btn-1
					',
					'fields_options' => [
						'background' => [
							'label' => esc_html__( 'Button BG Color ', 'goyto-plugin' ),
							'description' => esc_html__( 'Choose background type and style.', 'goyto-plugin' ),
							'separator' => 'before',
						]
					]
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'goyto-plugin' ),
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'button_bg_hover_color',
					'types' => [ 'gradient' ],
					'exclude' => [ 'image' ],
					'selector' => '
						{{WRAPPER}} .fd-pr-btn-1:hover,
						{{WRAPPER}} .fd-pr-btn-1::after
					',
					'fields_options' => [
						'background' => [
							'label' => esc_html__( 'Button Hover BG Color ', 'goyto-plugin' ),
							'description' => esc_html__( 'Choose background type and style.', 'goyto-plugin' ),
							'separator' => 'before',
						]
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();



	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings );
		if ( ! empty( $settings['btn_link']['url'] ) ) {
			$this->add_link_attributes( 'btn_link', $settings['btn_link'] );
		}

		require __DIR__ . '/view/header/header-' . $style . '.php';
    }

	/**
	 * Search Body Display
	 *
	 * @return void
	 */
	protected function ___search_body(){
		$settings = $this->get_settings_for_display();
		?>

	<div class="popup-search-box search_1_popup_active ">
		<button aria-label="search" type="button" class="popup-search-box-close search_1_popup_close">
			<i class="fa-solid fa-xmark"></i>
		</button>

		<div class="container popup-search-box-container">

			<?php if(!empty($settings['search_title'])):?>
				<h4 class="title kd-heading-1 ftc-font-700 t text-capitalize"><?php echo esc_html($settings['search_title']);?></h4>
			<?php endif;?>

			<div class="popup-search-box-form">
				<form action="<?php echo esc_url(home_url( '/' ));?>">
					<div class="popup-search-box-input">

						<input class="search-input" required type="search" name="s" aria-label="search" placeholder="<?php esc_attr_e( 'Search Keywords..', 'fladient-plugin' );?>" value="<?php print esc_attr( get_search_query() )?>">
					</div>
					<button aria-label="search" type="submit"><i class="fal fa-search"></i></button>
				</form>
			</div>
		</div>
	</div>
<?php 
}



/**
 * Mobile Menu Display
 *
 * @return void
 */
protected function __mobile_menu(){ 
	$settings = $this->get_settings_for_display();
?>
<div class="mobile-menu lenis lenis-smooth" >
		<div class="mobile-menu-wrap">

			
			<div class="mobile-menu-logo-wrap mb-40">
				<a href="<?php echo esc_url(home_url( '/' ));?>" class="mobile-menu-logo d-block" aria-label="brand-logo"  >
					<img src="<?php echo esc_url($settings['mrzlogo']['url']);?>" alt="<?php if(!empty($settings['mrzlogo']['alt'])){ echo esc_attr($settings['mrzlogo']['alt']);}else{esc_attr_e('Shape', 'gtbus-plugin');}?>">
				</a>
				<div class="mobile-menu-close open_menu" id="menuToggle2">
					<i class="fa-solid fa-xmark"></i>
				</div>
			</div>
			<?php if(!empty($settings['shortdesc'])):?>
				<p class="fd-para-2 mobile-menu-disc"><?php echo fladient_wp_kses($settings['shortdesc']);?></p>
			<?php endif;?>

			<!-- search-form -->
			<div class="mobile-menu-search-bar">
				<form action="<?php echo esc_url(home_url( '/' ));?>" class="mobile-menu-search-form-1 mb-50" >
					<input type="text" name="search" placeholder="<?php esc_attr_e( 'Search', 'gtbus-plugin' );?>" value="<?php echo get_search_query();?>">
					<button class="form-btn" type="button" aria-label="name" >
						<i class="fa-solid fa-magnifying-glass"></i>
					</button>

				</form>
			</div>

			<!-- mobile-menu-list -->
			<div class="mobile-menu-navigation">
				<nav class="mobile-main-navigation  clearfix ul-li">
					<?php
						echo str_replace(['menu-item-has-children', 'sub-menu'], ['dropdown', 'dropdown-menu clearfix'], wp_nav_menu( array(
							'echo'           => false,
							'menu' => !empty($settings['choose-menu']) ? $settings['choose-menu'] : 'menu-1',
							'menu_id'        =>'main-nav',
							'menu_class'        =>'nav navbar-nav clearfix',
							'container'=>false,
							'fallback_cb'    => 'Navwalker_Class::fallback',
							'walker'         => class_exists( 'Rs_Mega_Menu_Walker' ) ? new \Rs_Mega_Menu_Walker : '',
						)) );
					?>
				</nav>
			</div>

			<ul class="mobile-menu-contact">
				<?php foreach($settings['infos'] as $item):?>
					<li>
						<span class="icon">
							<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						</span>
						<span class="content">
							<h6 class="title fd-heading-4"> <?php echo fladient_wp_kses($item['title'])?> </h6>
							<p class="disc fd-heading-4"><?php echo fladient_wp_kses($item['description'])?></p>
						</span>
					</li>
				<?php endforeach;?>
			</ul>

			<!-- social-link -->
			<div class="mobile-menu-social-1 ">
				<?php foreach($settings['socials'] as $item):?>
					<a href="<?php echo esc_url($item['link']['url']);?>" aria-label="name" data-toggle="tooltip" data-placement="bottom" title="<?php echo esc_attr($item['name']);?>">
						<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</a>
				<?php endforeach;?>
			</div>


		</div>

		<div class="mobile_menu_overlay open_menu"></div>
	</div>
	<?php }


}


Plugin::instance()->widgets_manager->register( new Fladient_Header() );