<?php

/**
 * Elementor Single Widget
 * @package fladient Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Fladient_Image_Box extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-img--bx';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Image Box', 'fladient-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fladient-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fladient_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Feature Box Select', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'fladient-plugin' ),
					'2'  => esc_html__( 'Style 2', 'fladient-plugin' ),
					'3'  => esc_html__( 'Style 3', 'fladient-plugin' ),
					'4'  => esc_html__( 'Style 4', 'fladient-plugin' ),
					'5'  => esc_html__( 'Style 5', 'fladient-plugin' ),
					'6'  => esc_html__( 'Style 6', 'fladient-plugin' ),
					'7'  => esc_html__( 'Style 7', 'fladient-plugin' ),
					'8'  => esc_html__( 'Style 8', 'fladient-plugin' ),
					'9'  => esc_html__( 'Style 9', 'fladient-plugin' ),
					'10'  => esc_html__( 'Style 10', 'fladient-plugin' ),
					'11'  => esc_html__( 'Style 11', 'fladient-plugin' ),
					'12'  => esc_html__( 'Style 12', 'fladient-plugin' ),
					'13'  => esc_html__( 'Style 13', 'fladient-plugin' ),
					'14'  => esc_html__( 'Style 14', 'fladient-plugin' ),
					'15'  => esc_html__( 'Style 15', 'fladient-plugin' ),
					'16'  => esc_html__( 'Style 16', 'fladient-plugin' ),
					'17'  => esc_html__( 'Style 17', 'fladient-plugin' )
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'--img-option',
			[
				'label' => esc_html__( 'Image Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $this->add_control(
			'img_1', [
				'label' => esc_html__( 'Image 1', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'img_2', [
				'label' => esc_html__( 'Image 2', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'condition' => [
                    'style' => ['2', '3', '4', '5', '7', '8', '9', '10', '12', '13', '15'],
                ],
			]
		);
        $this->add_control(
			'img_3', [
				'label' => esc_html__( 'Image 3', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'condition' => [
                    'style' => ['2', '4', '7', '9', '10', '12'],
                ],
			]
		);
        $this->add_control(
			'img_4', [
				'label' => esc_html__( 'Image 4', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'condition' => [
                    'style' => ['2', '4', '7', '9', '12'],
                ],
			]
		);
        $this->add_control(
			'img_5', [
				'label' => esc_html__( 'Image 5', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'condition' => [
                    'style' => ['2', '4', '12'],
                ],
			]
		);
        $this->add_control(
			'img_6', [
				'label' => esc_html__( 'Image 6', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'condition' => [
                    'style' => ['4', '12'],
                ],
			]
		);
        $this->add_control(
			'img_7', [
				'label' => esc_html__( 'Image 7', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'condition' => [
                    'style' => ['4', '12'],
                ],
			]
		);
        $this->add_control(
			'rating',
			[
				'label' => esc_html__( 'Rating', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5,
				'step' => 1,
				'default' => 5,
				'condition' => [
                    'style' => ['12'],
                ],
			]
		);
		$this->add_control(
			'rating_txt', [
				'label' => esc_html__( 'Rating Text', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
				'condition' => [
                    'style' => ['12'],
                ],
			]
		);
		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/image-box/image-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Fladient_Image_Box() );