<?php

/**
 * Elementor Single Widget
 * @package fladient Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Fladient_Info_Box extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-info-box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Info Box', 'fladient-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fladient-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fladient_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Style Select', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'fladient-plugin' ),
					'2'  => esc_html__( 'Style 2', 'fladient-plugin' ),
					'3'  => esc_html__( 'Style 3', 'fladient-plugin' ),
					'4'  => esc_html__( 'Style 4', 'fladient-plugin' ),
					'5'  => esc_html__( 'Style 5', 'fladient-plugin' ),
					'6'  => esc_html__( 'Style 6', 'fladient-plugin' ),		
					'7'  => esc_html__( 'Style 7', 'fladient-plugin' ),
					'8'  => esc_html__( 'Style 8', 'fladient-plugin' )				
				]
			]
		);
        $this->end_controls_section();
        
        $this->start_controls_section(
			'--fs-slider-option',
			[
				'label' => esc_html__( 'Feature Slider Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'layout',
			[
				'label' => esc_html__( 'Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'fladient-plugin' ),
					'2'  => esc_html__( 'Style 2', 'fladient-plugin' ),
					'3'  => esc_html__( 'Style 3', 'fladient-plugin' ),
					'4'  => esc_html__( 'Style 4', 'fladient-plugin' ),
					'5'  => esc_html__( 'Style 5', 'fladient-plugin' )
				]
			]
		);
        $repeater->add_control(
            'type',
            [
                'label'          => __( 'Icon Type', 'fladient-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'image' => [
                        'title' => __( 'Image', 'fladient-core' ),
                        'icon'  => 'eicon-image',
                    ],
                    'icon' => [
                        'title' => __( 'Icon', 'fladient-core' ),
                        'icon'  => 'eicon-hypster',
                    ],
                ],
				'condition'      => [
                    'layout' => ['1', '2', '4', '5'],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                
            ]
        );
        
        $repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'      => [
                    'type' => 'image',
					'layout' => ['1', '2', '4', '5'],
                ],
			]
		);
        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'fladient-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'      => [
                    'type' => 'icon',
					'layout' => ['1', '2', '4', '5'],
                ],
			]
		);
		
		$repeater->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .item-icon' => 'background: {{VALUE}}',
				],
				'condition'      => [
					'layout' => ['1'],
                ],
			]
		);
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'fladient-plugin' ),
				'default' => esc_html__( 'Info Title', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
				'condition'      => [
                    'layout' => '2',
                ],
			]
		);
		$repeater->add_control(
			'custom_clas', [
				'label' => esc_html__( 'Custom Class', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'condition'      => [
                    'layout' => ['2', '1', '4'],
                ],
			]
		);
        $repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'fladient-plugin' ),
				'default' => esc_html__( 'Info Description', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
				'condition'      => [
                    'layout' => ['1', '4'],
                ],
			]
		);
		$repeater->add_control(
			'line_shape', [
				'label' => esc_html__( 'Svg Shape', 'fladient-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'      => [
					'layout' => ['4'],
                ],
			]
		);
		$repeater->add_control(
			'box_bg_shape', [
				'label' => esc_html__( 'Box BG Shape', 'fladient-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'      => [
					'layout' => ['5'],
                ],
			]
		);
        $this->add_control(
			'features',
			[
				'label' => esc_html__( 'Add Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->add_control(
			'footer_desc',
			[
				'label' => esc_html__( 'Description', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Type your description here', 'fladient-plugin' ),
				'condition'      => [
                    'style' => '2',
                ],
			]
		);
		$this->end_controls_section();
        
		$this->start_controls_section(
			'info-box-style',
			[
				'label' => esc_html__( 'Info Box Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'      => [
                    'style' => ['6'],
                ],
			]
		);
		$this->add_control(
			'icon-box-bgc',
			[
				'label' => esc_html__( 'Info Box BG Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fd-feature-4-item .fd-services-2-item' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'box-padding',
			[
				'label' => esc_html__( 'Padding', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .fd-feature-4-item .fd-services-2-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'info-icon-style',
			[
				'label' => esc_html__( 'Info Icon Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'info_icon_color',
			[
				'label' => esc_html__( 'Info Icon Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'slider_sub_title_style',
			[
				'label' => esc_html__( 'Title Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'ttl_margin',
			[
				'label' => esc_html__( 'Title Margin', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-info-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-info-title' => 'color: {{VALUE}}',
				],
			]
		);
		// typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'm_s_typography',
				'selector' => '{{WRAPPER}} .elementor-info-title',
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'slider_desc_style',
			[
				'label' => esc_html__( 'Desc Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'desc_margin',
			[
				'label' => esc_html__( 'Desc Margin', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .item-disc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'desc_color',
			[
				'label' => esc_html__( 'Desc Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-disc' => 'color: {{VALUE}}',
				],
			]
		);
		// typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'desc_typography',
				'selector' => '{{WRAPPER}} .item-disc',
			]
		);

		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/info-box/info-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Fladient_Info_Box() );