<?php

/**
 * Elementor Single Widget
 * @package fladient Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Fladient_Video_Popup extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-video-popup';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Video Popup', 'fladient-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fladient-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fladient_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Video Popup Select', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'fladient-plugin' ),
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'--video-option',
			[
				'label' => esc_html__( 'Videp Popup Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $this->add_control(
			'popup_bg', [
				'label' => esc_html__( 'Video BG Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'overlay_bg', [
				'label' => esc_html__( 'Video Overlay Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
       
        $this->add_control(
			'video_link', [
				'label' => esc_html__( 'Video Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'feedback_style',
			[
				'label' => esc_html__( 'Video Popup Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
        $this->add_control(
			'video_btn_bg',
			[
				'label' => esc_html__( 'Video Button BG Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fd-plybtn-1:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/video-popup/video-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Fladient_Video_Popup() );