<?php 
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="p-relative">
<div class="fd-advantages-2-row mb-75">
    <div class="left z-index-3">
        <?php if(!empty($settings['img_1']['url'])):?>
            <div class="arrow-illus">
                <img src="<?php echo esc_url($settings['img_1']['url']);?>" alt="<?php if(!empty($settings['img_1']['alt'])){ echo esc_attr($settings['img_1']['alt']);}?>">
            </div>
        <?php endif;?>
        <div class="fd-advantages-2-content ">
            <?php if(!empty($settings['img_2']['url'])):?>
                <div class="content-img ">
                    <img class="txaafadedown" src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){ echo esc_attr($settings['img_2']['alt']);}?>">
                </div>
            <?php endif;?>
            <div class="content">

                <?php if(!empty($settings['title'])):?>
                    <h5 class="content-title fd-heading-2 fd-font-800 wow" data-splitting=""><?php echo fladient_wp_kses($settings['title'])?></h5>
                <?php endif;?>

                <?php if(!empty($settings['description'])):?>
                    <p class="fd-para-2 content-disc txaafadedown"><?php echo fladient_wp_kses($settings['description'])?></p>
                <?php endif;?>

                <ul class="fd-list-1 mb-35">
                    <?php foreach($settings['lists'] as $item):?>
                    <li class="txaafadedown">
                        <span class="icon">
                            <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                        <?php echo fladient_wp_kses($item['title']);?>
                    </li>
                    <?php endforeach;?>
                </ul>
                
                <div class="txaafadedown">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-capitalize">
                        <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                    </a>
                </div>

            </div>
        </div>
    </div>
    <div class="right p-relative">
        <?php if(!empty($settings['img_3']['url'])):?>
            <div class="fd-advantages-2-img fix img-cover txaafadedown">
                <img src="<?php echo esc_url($settings['img_3']['url']);?>" alt="<?php if(!empty($settings['img_3']['alt'])){ echo esc_attr($settings['img_3']['alt']);}?>">
            </div>
        <?php endif;?>
        <?php if(!empty($settings['img_4']['url'])):?>
            <div class="fd-advantages-2-img-2 fix img-cover txaafadedown">
                <img src="<?php echo esc_url($settings['img_4']['url']);?>" alt="<?php if(!empty($settings['img_4']['alt'])){ echo esc_attr($settings['img_4']['alt']);}?>">
            </div>
        <?php endif;?>
    </div>
</div>
    <?php if(!empty($settings['info_description'])):?>
        <h5 class="fd-advantages-2-qoute fd-heading-2 fd-font-800 text-center wow" data-splitting=""><?php echo fladient_wp_kses($settings['info_description'])?></h5>
    <?php endif;?>
</div>