<?php 
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="section">
    <div class="fd-advantage-5-area bg-default  fix p-relative fd-full-screen fd-full-screen-none justify-content-center align-items-center d-flex" data-background="<?php echo esc_url($settings['img_1']['url']);?>">
        <div class="container fd-hero-5-container">
            <div class="fd-advantage-5-content">
                <?php if(!empty($settings['title'])):?>
                    <div class="fix">
                        <h1 class="fd-scn-title-3 fd-h5-title-ani-1 fd-transition-3 fd-delay-500 "><?php echo fladient_wp_kses($settings['title'])?></h1>
                    </div>
                <?php endif;?>
                <?php if(!empty($settings['description'])):?>
                    <div class="fix mb-45">
                        <p class="fd-para-3 fd-advantage-5-disc fd-h5-title-ani-1 fd-transition-3 fd-delay-1000"><?php echo fladient_wp_kses($settings['description'])?></p>
                    </div>
                <?php endif;?>

                
                <div class="fd-advantage-5-feature mb-50">
                    <?php foreach($settings['infos'] as $item):?>
                        <div class="fd-advantage-5-feature-item fd-fade-down-1 fd-transition-3 fd-delay-1000">
                            <div class="item-icon d-flex align-items-center justify-content-center">
                                <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </div>
                            <h5 class="item-title fd-heading-5 fd-font-600"><?php echo fladient_wp_kses($item['title'])?></h5>
                        </div>
                    <?php endforeach;?>

                </div>

                <div class="fd-advantage-5-content-btn d-flex flex-wrap align-items-center fd-fade-down-1 fd-transition-3 fd-delay-2000">

                    <?php if(!empty($settings['btn_label'])):?>
                        <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-capitalize has-h5-black">
                            <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                        </a>
                    <?php endif;?>
                    <?php if(!empty($settings['socials'])):?>
                        <div class="fd-header-2-social ">
                            <?php foreach($settings['socials'] as $item):?>
                                <a href="<?php echo esc_url($item['link']['url']);?>" aria-label="name" class="item-link">
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </a>
                            <?php endforeach;?>

                        </div>
                    <?php endif;?>
                </div>
            </div>
        </div>

        <div class="fd-hero-5-social  ">
            <div class="container fd-hero-5-container">
                <div class="fd-hero-5-social-wrap d-flex  justify-content-end">
                    <?php if(!empty($settings['support_link']['url'])):?>
                        <a href="<?php echo esc_url($settings['support_link']['url']);?>" aria-label="name" class="fd-support-btn">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </a>
                    <?php endif;?>
                </div>
            </div>
        </div>
        <?php if(!empty($settings['img_2']['url'])):?>
            <div class="fd-advantage-5-img-posi">
                <div class="fd-advantage-5-img fix">
                    <img class="fd-h5-img-down fd-transition-3" src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){ echo esc_attr($settings['img_2']['alt']);}?>">
                </div>
            </div>
        <?php endif;?>
    </div>
</div>