<div class="fd-faq-1-area pt-130 pb-130">
    <div class="container fd-container-1">
        <div class="fd-faq-1-wrap">
            <div class="fd-faq-1-row">

                <div class="fd-faq-1-left">
                    <ul class="fd-faq-1-tabs-btn mb-20" id="myTab" role="tablist">
                        <?php
                            foreach( $settings['tabs'] as $id => $item ) :
                            $active = ($id == 0) ? 'active' : '';
                            $aria_selected = ($id == 0) ? 'true' : 'false';
                        ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo esc_attr($active); ?> fd-heading-1 fd-font-500" id="home-tab<?php echo esc_attr($id); ?>" data-bs-toggle="tab" data-bs-target="#home<?php echo esc_attr($id); ?>" type="button" role="tab" aria-controls="home<?php echo esc_attr($id); ?>" aria-selected="true">
                            <span class="text"><?php echo esc_html($item['tab_title']);?></span>
                            <i class="fa-solid fa-arrow-right-long"></i></button>
                        </li>
                        <?php endforeach;?>

                    </ul>

                    <div class="fd-faq-1-card text-center">
                        <div class="card-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </div>

                        <?php if(!empty($settings['title'])):?>
                            <h5 class="card-title fd-heading-1 fd-font-800"><?php echo fladient_wp_kses($settings['title'])?></h5>
                        <?php endif;?>

                        <?php if(!empty($settings['description'])):?>
                            <p class="fd-para-1 card-disc"><?php echo fladient_wp_kses($settings['description'])?></p>
                        <?php endif;?>

                        <?php if(!empty($settings['btn_label'])):?>
                            <div class="card-btn">
                                <a href="<?php echo esc_url($settings['btn_link']['url']);?>" aria-label="name" class="fd-pr-btn-1 text-capitalize">
                                    <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                                </a>
                            </div>
                        <?php endif;?>
                    </div>
                </div>

                <div class="tab-content fd-faq-1-tabs-pane" id="myTabContent">
                    <?php
                        foreach( $settings['tabs'] as $id => $item ) :
                        $active = ($id == 0) ? 'show active' : '';
                    ?>
                    <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="home<?php echo esc_attr($id); ?>" role="tabpanel" aria-labelledby="home-tab<?php echo esc_attr($id); ?>">
                        <div class="fd-faq-1-accordion" id="accordionExample_31">

                            <?php 
                                $rand__id = rand( 457788, 45785 ); 
                                foreach($item['faqs'] as $id => $list):
                                $collapsed_tab = ($id == 0) ? '' : 'collapsed';
                                $area_expanded = ($id == 0) ? 'true' : 'false';
                                $active_show_tab = ($id == 0) ? 'show' : '';    
                                $active_show_bg = ($id == 0) ? 'faq_active' : '';    
                            ?>
                            <div class="fd-faq-1-accordion-item mb-15" >
                                <div class="item-header" id="heading<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($list['_id'] ); ?>">
                                    <button class="item-title fd-heading-1 fd-font-600 <?php echo esc_attr($collapsed_tab);?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($list['_id'] ); ?>" aria-expanded="false" aria-controls="collapse<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($list['_id'] ); ?>">
                                        <span class="icon-2">
                                            <i class="flaticon-star flaticon"></i>
                                        </span>
                                        <span class="text"><?php echo fladient_wp_kses($list['faq_title']);?></span>
                                        <span class="icon">
                                            <i class="fa-solid fa-plus"></i>
                                        </span>
                                    </button>
                                </div>
                                <div id="collapse<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($list['_id'] ); ?>" class="accordion-collapse collapse <?php echo esc_attr($active_show_tab);?>" aria-labelledby="heading<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($list['_id'] ); ?>" data-bs-parent="#accordionExample_<?php echo esc_attr( $rand__id );?>">
                                    <div class="item-body ">
                                        <p class="disc fd-para-1 has-para-sm">
                                            <?php echo fladient_wp_kses($list['faq_description']);?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach;?>
                            
                        </div>
                    </div>
                    <?php endforeach;?>

                </div>

            </div>
        </div>

    </div>
    </div>