<?php 
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="fd-feature-5-area bg-default  fix p-relative fd-full-screen fd-full-screen-none justify-content-center align-items-center d-flex" data-background="<?php echo esc_url($settings['img_1']['url']);?>">
    <div class="container fd-hero-5-container">
        <div class="fd-feature-5-content text-center mb-35">
            <?php if(!empty($settings['title'])):?>
                <div class="fix">
                    <h1 class="fd-scn-title-3 fd-transition-3 fd-delay-500 fd-h5-title-ani-1"><?php echo fladient_wp_kses($settings['title'])?></h1>
                </div>
            <?php endif;?>
            <?php if(!empty($settings['description'])):?>
                <div class="fix mb-40">
                    <p class="fd-para-3 fd-feature-5-disc fd-transition-3 fd-delay-1000 fd-h5-title-ani-1"><?php echo fladient_wp_kses($settings['description'])?></p>
                </div>
            <?php endif;?>

            <?php if(!empty($settings['btn_label'])):?>
                <div class="fd-fade-down-1 fd-delay-1500 fd-transition-3">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-uppercase has-h5-pr-1 has-shadow">
                        <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                    </a>
                </div>
            <?php endif;?>

        </div>

        <div class="fd-feature-5-img-wrap p-relative text-center">
            <?php if(!empty($settings['img_2']['url'])):?>
                <div class="fd-feature-5-img fix">
                    <img class="fd-h5-img-down fd-transition-3 fd-delay-1000" src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){ echo esc_attr($settings['img_2']['alt']);}?>">
                </div>
            <?php endif;?>
            <?php $i = 0; foreach($settings['features'] as $item): $i++?>
                <div class="fd-feature-5-img-btn-<?php echo esc_attr($i);?>">
                    <span class="line"></span>
                    <a href="<?php echo esc_url($item['link']['url']);?>" aria-label="name" class="fd-pr-btn-1 text-uppercase has-h5-pr-1">
                        <span class="text" data-back="<?php echo esc_attr($item['title']);?>" data-front="<?php echo esc_attr($item['title']);?>"></span>
                    </a>
                </div>
            <?php endforeach;?>

        </div>

    </div>

    <div class="fd-hero-5-social  fd-fade-down-1 fd-transition-3 fd-delay-2000">
        <div class="container fd-hero-5-container">
            <div class="fd-hero-5-social-wrap d-flex align-items-center justify-content-between flex-wrap">
                <?php if(!empty($settings['socials'])):?>
                    <div class="fd-header-2-social ">
                        <?php foreach($settings['socials'] as $item):?>
                            <a href="<?php echo esc_url($item['link']['url']);?>" aria-label="name" class="item-link">
                                <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </a>
                        <?php endforeach;?>

                    </div>
                <?php endif;?>

                <?php if(!empty($settings['support_link']['url'])):?>
                    <a href="<?php echo esc_url($settings['support_link']['url']);?>" aria-label="name" class="fd-support-btn">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </a>
                <?php endif;?>
            </div>
        </div>

    </div>
</div>