<?php 
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="section">
    <div class="fd-hero-5-area bg-default fix p-relative fd-full-screen justify-content-center align-items-center d-flex" data-background="<?php echo esc_url($settings['img_1']['url']);?>">
        <div class="container fd-hero-5-container">
            <div class="fd-hero-5-content">
                <?php if(!empty($settings['subtitle'])):?>
                    <div class="left">
                        <h1 class="fd-hero-5-title fd-heading-5 fd-font-800 " fd-h5-slide-left><?php echo fladient_wp_kses($settings['subtitle'])?></h1>
                    </div>
                <?php endif;?>
                <div class="right">
                    <?php if(!empty($settings['title'])):?>
                        <h1 class="fd-hero-5-title-2 fd-heading-5 fd-font-800 p-relative " fd-h5-slide-down><?php echo fladient_wp_kses($settings['title'])?> 
                            <?php if(!empty($settings['badge'])):?>
                                <span><?php echo esc_html($settings['badge']);?></span>
                            <?php endif;?>
                        </h1>
                    <?php endif;?>
                    <div class="inner-div">
                        <?php if(!empty($settings['description'])):?>
                            <p class="fd-para-3 fd-hero-5-disc " fd-h5-slide-down ><?php echo fladient_wp_kses($settings['description'])?> </p>
                        <?php endif;?>

                        <?php if(!empty($settings['btn_label'])):?>
                            <div class="d-inline-block" fd-h5-slide-down  >
                                <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-capitalize has-h5-pr-1 has-shadow" >
                                    <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                                </a>
                            </div>
                        <?php endif;?>

                    </div>
                </div>
            </div>
        </div>

        <div class="fd-hero-5-social  " fd-h5-slide-down>
            <div class="container fd-hero-5-container">
                <div class="fd-hero-5-social-wrap d-flex align-items-center justify-content-between flex-wrap">
                    <?php if(!empty($settings['socials'])):?>
                        <div class="fd-header-2-social ">
                            <?php foreach($settings['socials'] as $item):?>
                                <a href="<?php echo esc_url($item['link']['url']);?>" aria-label="name" class="item-link">
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </a>
                            <?php endforeach;?>

                        </div>
                    <?php endif;?>
                    <?php if(!empty($settings['support_link']['url'])):?>
                        <a href="<?php echo esc_url($settings['support_link']['url']);?>" aria-label="name" class="fd-support-btn">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </a>
                    <?php endif;?>
                </div>
            </div>

        </div>

        <?php if(!empty($settings['img_2']['url'])):?>
            <div class="fd-hero-5-img fix">
                <img fd-h5-img-down src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){ echo esc_attr($settings['img_2']['alt']);}?>">
            </div>
        <?php endif;?>
    </div>                    
</div>