<?php 
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="fd-hero-4-area p-relative fix" data-background="<?php echo esc_url($settings['img_1']['url']);?>">
    <div class="container fd-container-3">
        <div class="fd-hero-4-content  text-center">
            <?php if(!empty($settings['subtitle'])):?>
                <h6 class="fd-heading-4 elementor-fladient-sub fd-hero-4-subtitle text-uppercase fd-font-900 txaa-ani-subtitle-3 txaa-split-subtitle-3"><?php echo fladient_wp_kses($settings['subtitle'])?></h6>
            <?php endif;?>

            <div class="fd-hero-4-title">
                <div class="swiper-container fix fd-hero-4-active">
                    <div class="swiper-wrapper">
                            <?php foreach($settings['contents'] as $item):?>
                                <div class="swiper-slide">
                                    <h1 class="word elementor-gt-heading fd-hero-4-title-single fd-heading-4 fd-font-600">
                                        <?php echo fladient_wp_kses($item['title'])?>
                                    </h1>
                                </div>
                            <?php endforeach;?>
                        
                    </div>
                </div>
            </div>
                
            <?php if(!empty($settings['description'])):?>
                <p class="fd-para-2 fd-hero-4-disc"><?php echo fladient_wp_kses($settings['description'])?></p>
            <?php endif;?>

            <?php if(!empty($settings['btn_label'])):?>
                <div class="fd-hero-4-btn">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-uppercase has-clr-pr-2">
                        <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                    </a>
                </div>
            <?php endif;?>
        </div>
    </div>

    <div class="fd-hero-4-bg">
        <span class="fd-hero-4-bg-circle-1"></span>
        <span class="fd-hero-4-bg-circle-2"></span>
        <span class="fd-hero-4-bg-circle-3"></span>
        <span class="fd-hero-4-bg-circle-4"></span>
    </div>
    </div>