<?php 

    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="fd-hero-1-area">
    <div class="container">
        <div class="fd-hero-1-content text-center">
            <?php if(!empty($settings['subtitle'])):?>
                <div class="fd-subtitle-1">
                    <?php if($settings['hide_icon_subtitle'] === 'yes'):?>
                        <img class="fd-subtitle-1-icon" src="<?php echo esc_url($settings['subtitle_icon']['url']);?>" alt="<?php if(!empty($settings['subtitle_icon']['alt'])){ echo esc_attr($settings['subtitle_icon']['alt']);}?>">
                    <?php endif;?>
                    <h6 class="elementor-fladient-sub fd-subtitle-1-text text-capitalize txaa-ani-subtitle-1 txaa-split-subtitle-1 "><?php echo fladient_wp_kses($settings['subtitle'])?></h6>
                </div>
            <?php endif;?>
            <?php if(!empty($settings['title'])):?>    
                <h1 class="hero-title fd-heading-1 fd-font-900 txaa-ani-subtitle-1 txaa-split-subtitle-1 elementor-gt-heading"><?php echo fladient_wp_kses($settings['title'])?></h1>
            <?php endif;?>

            <?php if(!empty($settings['description'])):?> 
                <p class="fd-para-1 hero-disc fd-hero-1-slideup"><?php echo fladient_wp_kses($settings['description'])?></p>
            <?php endif;?>
            <?php if(!empty($settings['btn_label'])):?>
                <div class="hero-btn fd-hero-1-slideup">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-capitalize">
                        <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                    </a>
                </div>
            <?php endif;?>
        </div>
    </div>

    <div class="fd-hero-1-app-screen">
        <div class="fd-hero-1-app-screen-width">
            <?php if(!empty($settings['img_1']['url'])):?>
                <div class="fd-hero-1-app-screen-1 fd-hero-1-slideleft">
                    <img src="<?php echo esc_url($settings['img_1']['url']);?>" alt="<?php if(!empty($settings['img_1']['alt'])){ echo esc_attr($settings['img_1']['alt']);}?>">
                </div>
            <?php endif;?>
            <?php if(!empty($settings['img_2']['url'])):?>
                <div class="fd-hero-1-app-screen-2 fd-hero-1-slideleft">
                    <img src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){ echo esc_attr($settings['img_2']['alt']);}?>">
                </div>
            <?php endif;?>
            <?php if(!empty($settings['img_3']['url'])):?>
                <div class="fd-hero-1-app-screen-3 fd-hero-1-slideleft">
                    <img src="<?php echo esc_url($settings['img_3']['url']);?>" alt="<?php if(!empty($settings['img_3']['alt'])){ echo esc_attr($settings['img_3']['alt']);}?>">
                </div>
            <?php endif;?>
            <?php if(!empty($settings['img_4']['url'])):?>
                <div class="fd-hero-1-app-screen-4 fd-hero-1-slideright">
                    <img src="<?php echo esc_url($settings['img_4']['url']);?>" alt="<?php if(!empty($settings['img_4']['alt'])){ echo esc_attr($settings['img_4']['alt']);}?>">
                </div>
            <?php endif;?>
            <?php if(!empty($settings['img_5']['url'])):?>
                <div class="fd-hero-1-app-screen-5 fd-hero-1-slideright">
                    <img src="<?php echo esc_url($settings['img_5']['url']);?>" alt="<?php if(!empty($settings['img_5']['alt'])){ echo esc_attr($settings['img_5']['alt']);}?>">
                </div>
            <?php endif;?>
            <?php if(!empty($settings['img_6']['url'])):?>
                <div class="fd-hero-1-app-screen-6 fd-hero-1-slideright">
                    <img src="<?php echo esc_url($settings['img_6']['url']);?>" alt="<?php if(!empty($settings['img_6']['alt'])){ echo esc_attr($settings['img_6']['alt']);}?>">
                </div>
            <?php endif;?>
            <?php if(!empty($settings['img_7']['url'])):?>
                <div class="fd-hero-1-app-screen-7 fd-hero-1-slideright">
                    <img src="<?php echo esc_url($settings['img_7']['url']);?>" alt="<?php if(!empty($settings['img_7']['alt'])){ echo esc_attr($settings['img_7']['alt']);}?>">
                </div>
            <?php endif;?>
        </div>
    </div>
    <?php if(!empty($settings['img_8']['url'])):?>
        <div class="fd-hero-1-bg-illus fd-hero-1-slideup">
            <img src="<?php echo esc_url($settings['img_8']['url']);?>" alt="<?php if(!empty($settings['img_8']['alt'])){ echo esc_attr($settings['img_8']['alt']);}?>">
        </div>
    <?php endif;?>
    <?php if(!empty($settings['img_9']['url'])):?>
        <img class="fd-hero-1-bg-shape" src="<?php echo esc_url($settings['img_9']['url']);?>" alt="<?php if(!empty($settings['img_9']['alt'])){ echo esc_attr($settings['img_9']['alt']);}?>">
    <?php endif;?>
    </div>