<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading fd-heading-4 fd-overview-4-scn-title  fd-font-500 txaa-ani-subtitle-2 txaa-split-subtitle-2 h4-title-letter' );

    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="fd-overview-4-area">
    <div class="container fd-container-3">
        <div class="fd-overview-4-top">
            <?php if(!empty($settings['img_1']['url'])):?>
                <div class="fd-overview-2-img-1 img-cover fix txaascale0">
                    <img src="<?php echo esc_url($settings['img_1']['url']);?>" alt="<?php if(!empty($settings['img_1']['alt'])){ echo esc_attr($settings['img_1']['alt']);}?>">
                </div>
            <?php endif;?>
            <?php printf('<%1$s %2$s>%3$s</%1$s>',
                tag_escape($settings['title_tag']),
                $this->get_render_attribute_string('title'),
                $settings['title']
            ); ?>
        </div>

        <div class="fd-overview-4-bottom p-relative">
            <?php if(!empty($settings['img_2']['url'])):?>
                <span class="fd-overview-4-bottom-shape-1 txaafadedown">
                    <img src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){ echo esc_attr($settings['img_2']['alt']);}?>">
                </span>
            <?php endif;?>

            <?php if(!empty($settings['img_3']['url'])):?>
            <span class="fd-overview-4-bottom-shape-2 txaafadedown">
                <img src="<?php echo esc_url($settings['img_3']['url']);?>" alt="<?php if(!empty($settings['img_3']['alt'])){ echo esc_attr($settings['img_3']['alt']);}?>">
            </span>
            <?php endif;?>

            <div class="left">
                <?php if(!empty($settings['img_4']['url'])):?>
                    <div class="fd-overview-4-img-2 img-cover fix mt-80 mb-40 txaafadedown">
                        <img src="<?php echo esc_url($settings['img_4']['url']);?>" alt="<?php if(!empty($settings['img_4']['alt'])){ echo esc_attr($settings['img_4']['alt']);}?>">
                    </div>
                <?php endif;?>

                <div class="fd-overview-2-counter txaafadedown">
                    <?php if(!empty($settings['count'])):?>
                        <h4 class="counter-number fd-heading-2 fd-font-900"><span class="counter"><?php echo esc_html($settings['count']);?></span><?php if(!empty($settings['prefix'])){ echo esc_attr($settings['prefix']);}?></h4>
                    <?php endif;?>
                    <?php if(!empty($settings['counter_title'])):?>
                        <p class="fd-para-2 counter-disc"><?php echo fladient_wp_kses($settings['counter_title'])?></p>
                    <?php endif;?>
                </div>

            </div>
            <?php if(!empty($settings['img_5']['url'])):?>
                <div class="fd-overview-4-img-3 txaafadedown">
                    <img src="<?php echo esc_url($settings['img_5']['url']);?>" alt="<?php if(!empty($settings['img_5']['alt'])){ echo esc_attr($settings['img_5']['alt']);}?>">
                </div>
            <?php endif;?>
            <div class="right ">
                <div class="fd-para-2 fd-overview-4-disc txaafadedown elementor-gt-desc"><?php echo fladient_wp_kses($settings['description'])?></div>

                <ul class="fd-list-1 fd-overview-2-list mb-45">
                    <?php foreach($settings['lists'] as $item):?>
                        <li class="txaafadedown">
                            <span class="icon">
                                <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </span>
                            <?php echo fladient_wp_kses($item['title']);?>
                        </li>
                    <?php endforeach;?>
                </ul>
                <span class="fd-x-line mb-40 txaasx0"></span>

                <div class="fd-overview-2-btn d-flex align-items-center flex-wrap txaafadedown">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-capitalize has-clr-black-2">
                        <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                    </a>

                    <div class="fd-call-btn-1">
                        <div class="fd-call-btn-1-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['call_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </div>
                        <div class="fd-call-btn-1-content">
                            <?php if(!empty($settings['call_title'])):?>
                                <h6 class="fd-call-btn-1-title fd-heading-2 fd-font-500"><?php echo fladient_wp_kses($settings['call_title']) ?></h6>
                            <?php endif;?>
                            <a href="tel:<?php echo esc_url($settings['call_no']);?>" aria-label="name" class="fd-call-btn-1-link fd-heading-2 fd-font-900"><?php echo fladient_wp_kses($settings['call_no']) ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>