<?php 
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="fd-price-1-item txaafadedown">
    <?php if(!empty($settings['pricing_img']['url'])):?>
        <div class="item-img img-cover fix">
            <img src="<?php echo esc_url($settings['pricing_img']['url']);?>" alt="<?php if(!empty($settings['pricing_img']['alt'])){ echo esc_attr($settings['pricing_img']['alt']);}?>">
        </div>
    <?php endif;?>
    <div class="item-content">
        <?php if(!empty($settings['sub_title'])):?>
            <h4 class="item-subtitle fd-heading-1 fd-font-800 text-uppercase"><?php echo fladient_wp_kses($settings['sub_title']);?></h4>
        <?php endif;?>
        <?php if(!empty($settings['title'])):?>
            <h3 class="item-title fd-heading-1 fd-font-900 "><?php echo fladient_wp_kses($settings['title']);?></h3>
        <?php endif;?>
        <?php if(!empty($settings['text'])):?>
            <p class="item-disc fd-para-1 has-para-sm"><?php echo fladient_wp_kses($settings['text']);?></p>
        <?php endif;?>
    </div>
    <ul class="fd-list-1">
        <?php foreach($settings['lists'] as $list):?>
        <li>
            <span class="icon">
                <i class="fa-solid fa-check"></i>
            </span>
            <?php echo fladient_wp_kses($list['list']);?> 
        </li>
        <?php endforeach;?>
    </ul>
    <div class="btn-wrap text-center">
        <h4 class="item-price fd-heading-1 fd-font-800"><span><?php if(!empty($settings['currency'])){ echo esc_attr($settings['currency']);}?></span><?php if(!empty($settings['price'])){ echo esc_attr($settings['price']);}?></h4>
        <?php if(!empty($settings['btn_label'])):?>
            <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-capitalize has-clr-black-1">
                <span class="text" data-back="<?php echo esc_html($settings['btn_label']);?>" data-front="<?php echo esc_html($settings['btn_label']);?>"></span>
            </a>
        <?php endif;?>
    </div>
</div>