<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading fd-scn-title-1 has-clr-white' );

    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'b_btn_link', $settings['b_btn_link'] );
    }
?>
<div class="fd-benifit-workflow-area ">
    <?php if(!empty($settings['section_bg']['url'])):?>
        <img class="fd-benifit-workflow-bg" src="<?php echo esc_url($settings['section_bg']['url']);?>" alt="<?php if(!empty($settings['section_bg']['alt'])){echo esc_attr($settings['section_bg']['alt']);}?>">
    <?php endif;?>


    <div class="fd-benifit-1-area pt-150 pb-100 fix">
        <div class="container fd-container-1">
            <div class="row align-items-center">
                <!-- left-content -->
                <div class="col-lg-7">
                    <div class="fd-benifit-1-content">

                        <!-- scn-title -->
                        <div class="fd-benifit-1-scn-title mb-40">
                            <?php if(!empty($settings['subtitle'])):?>
                                <div class="fd-subtitle-1">
                                    <?php if(!empty($settings['title_shape']['url'])):?>
                                        <img class="fd-subtitle-1-icon" src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                                    <?php endif;?>  
                                    <h6 class="fd-subtitle-1-text text-capitalize "><?php echo fladient_wp_kses($settings['subtitle'], true);?></h6>
                                </div>
                            <?php endif;?>
                            <?php printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                fladient_wp_kses($settings['title'])
                            ); ?>
                        </div>


                        <div class="inner-div">

                            <?php if(!empty($settings['img_1']['url'])):?>
                                <div class="fd-benifit-1-img-1 fix img-cover">
                                    <img src="<?php echo esc_url($settings['img_1']['url']);?>" alt="<?php if(!empty($settings['img_1']['alt'])){echo esc_attr($settings['img_1']['alt']);}?>">
                                </div>
                            <?php endif;?>
                            <div class="right">

                                <?php if($settings['desc_show'] === 'yes'):?>
                                    <div class="fd-para-1 scn-disc has-clr-white"><?php echo fladient_wp_kses($settings['description']);?></div>
                                <?php endif;?>
                                <ul class="fd-list-1 mb-45">
                                    <?php foreach($settings['lists'] as $item):?>
                                    <li class="txaafadedown">
                                        <span class="icon">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </span>
                                        <?php echo fladient_wp_kses($item['title']);?>
                                    </li>
                                    <?php endforeach;?>
                                </ul>
                                <?php if(!empty($settings['btn_label'])):?>
                                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-capitalize has-clr-pr-1">
                                        <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                                    </a>
                                <?php endif;?>
                            </div>
    
                            

                        </div>

                    </div>
                </div>

                <?php if(!empty($settings['img_2']['url'])):?>
                    <div class="col-lg-5 pin">
                        <div class="fd-benifit-1-img-2 img-cover fix pin">
                            <img src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){echo esc_attr($settings['img_2']['alt']);}?>">
                        </div>
                    </div>
                <?php endif;?>
            </div>

        </div>
    </div>

    <div class="fd-workflow-1-area pt-100 pb-100">
        <div class="container fd-container-1">
            <div class="row align-items-center">
                

                <div class="col-lg-5">
                    <div class="fd-workflow-1-img-wrap">
                        <?php if(!empty($settings['b_img_1']['url'])):?>
                            <div class="fd-workflow-1-img-il img-cover fix">
                                <img src="<?php echo esc_url($settings['b_img_1']['url']);?>" alt="<?php if(!empty($settings['b_img_1']['alt'])){echo esc_attr($settings['b_img_1']['alt']);}?>">
                            </div>
                        <?php endif;?>
                        <?php if(!empty($settings['b_img_2']['url'])):?>
                            <div class="fd-workflow-1-img">
                                <img src="<?php echo esc_url($settings['b_img_2']['url']);?>" alt="<?php if(!empty($settings['b_img_2']['alt'])){echo esc_attr($settings['b_img_2']['alt']);}?>">
                            </div>
                        <?php endif;?>
                    </div>
                </div>

                <!-- right-content -->
                <div class="col-lg-7">
                    <div class="fd-workflow-1-content">

                        <!-- scn-title -->
                        <div class="fd-workflow-1-scn-title">
                            <?php if(!empty($settings['b_subtitle'])):?>
                                <div class="fd-subtitle-1">
                                    <?php if(!empty($settings['b_title_shape']['url'])):?>
                                        <img class="fd-subtitle-1-icon" src="<?php echo esc_url($settings['b_title_shape']['url']);?>" alt="<?php if(!empty($settings['b_title_shape']['alt'])){ echo esc_attr($settings['b_title_shape']['alt']);}?>"> 
                                    <?php endif;?>  
                                    <h6 class="fd-subtitle-1-text text-capitalize "><?php echo fladient_wp_kses($settings['b_subtitle'], true);?></h6>
                                </div>
                            <?php endif;?>
                            <h1 class="fd-scn-title-1 has-clr-white "><?php echo fladient_wp_kses($settings['b_title'])?></h1>
                        </div>

                        <div class="inner-div">
                            <div class="left">
                                <?php if(!empty($settings['b_description'])):?>
                                    <div class="fd-para-1 scn-disc has-clr-white"><?php echo fladient_wp_kses($settings['b_description'])?></div>
                                <?php endif;?>
                                <ul class="fd-list-1 mb-45">
                                    <?php foreach($settings['b_lists'] as $item):?>
                                    <li class="txaafadedown">
                                        <span class="icon">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </span>
                                        <?php echo fladient_wp_kses($item['title']);?>
                                    </li>
                                    <?php endforeach;?>
                                </ul>
                                <?php if(!empty($settings['b_btn_label'])):?>
                                    <a <?php echo $this->get_render_attribute_string( 'b_btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 text-capitalize has-clr-pr-1">
                                        <span class="text" data-back="<?php echo esc_attr($settings['b_btn_label']);?>" data-front="<?php echo esc_attr($settings['b_btn_label']);?>"></span>
                                    </a>
                                <?php endif;?>
                            </div>

                            

                            <div class="fd-workflow-1-item-wrap">
                                <?php foreach($settings['features'] as $item):?>
                                <div class="fd-feature-1-item ">
                                    <div class="item-icon txaascale2">
                                        <?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
                                            <img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'fladient-plugin');}?>">
                                        <?php else:?>
                                            <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        <?php endif;?>
                                    </div>
                                    <h4 class="item-title fd-heading-1 has-clr-white fd-font-800"><?php echo fladient_wp_kses($item['title']);?></h4>
                                    <p class="item-disc fd-para-1 has-para-sm"><?php echo fladient_wp_kses($item['description']);?></p>
                                </div>
                            <?php endforeach;?>
                            </div>

                        </div>

                        
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>