<?php 
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="fd-workflow-2-wrap txaafadedown">

    <div class="fd-workflow-2-content">
        <?php if(!empty($settings['title'])):?>
            <h1 class="fd-scn-title-2  txaa-ani-subtitle-2 txaa-split-subtitle-2"><?php echo fladient_wp_kses($settings['title'])?></h1>
        <?php endif;?>
        <?php if(!empty($settings['btn_label'])):?>
            <div class="txaafadedown">
                <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> aria-label="name" class="fd-pr-btn-1 has-clr-black-2 text-capitalize">
                    <span class="text" data-back="<?php echo esc_attr($settings['btn_label']);?>" data-front="<?php echo esc_attr($settings['btn_label']);?>"></span>
                </a>
            </div>
        <?php endif;?>

    </div>

    <!-- right -->
    <div class="fd-workflow-2-item-wrap">

        <?php foreach($settings['features'] as $item):?>
            <div class="fd-workflow-2-item">
                <div class="item-icon txaascale2">
                    <?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
                        <img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'fladient-plugin');}?>">
                    <?php else:?>
                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php endif;?>
                </div>
                <?php if(!empty($item['title'])):?>
                    <h4 class="item-title fd-heading-2 fd-font-800">
                        <a href=<?php echo esc_url($item['link']['url']);?>" aria-label="name"><?php echo fladient_wp_kses($item['title'])?></a>
                    </h4>
                <?php endif;?>
                <?php if(!empty($item['description'])):?>
                    <p class="fd-para-2 item-disc"><?php echo fladient_wp_kses($item['description'])?></p>
                <?php endif;?>
            </div>
        <?php endforeach;?>

    </div>
</div>