<?php

/**
 * Elementor Single Widget
 * @package fladient Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Fladient_Workflow extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-workflow-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Workflow Box', 'fladient-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fladient-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fladient_widgets' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
			'--top-section-option',
			[
				'label' => esc_html__( 'WorkFollow Option', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'fladient-plugin' ),
				'default' => esc_html__( 'Section Title', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
       
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'type',
            [
                'label'          => __( 'Icon Type', 'gesto-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'image' => [
                        'title' => __( 'Image', 'gesto-core' ),
                        'icon'  => 'eicon-image',
                    ],
                    'icon' => [
                        'title' => __( 'Icon', 'gesto-core' ),
                        'icon'  => 'eicon-hypster',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                
            ]
        );
        
        $repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'      => [
                    'type' => 'image',
                ],
			]
		);
        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'gesto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'      => [
                    'type' => 'icon',
                ],
			]
		);
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'fladient-plugin' ),
				'default' => esc_html__( 'Info Title', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'custom_clas', [
				'label' => esc_html__( 'Custom Class', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'fladient-plugin' ),
				'default' => esc_html__( 'Info Description', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'features',
			[
				'label' => esc_html__( 'Add Item', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'fladient-plugin' ),
				'default' => esc_html__( 'fladient Button', 'fladient-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'fladient-plugin' ),
				'type' => Controls_Manager::URL,
                'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
		$this->end_controls_section();
        
		$this->start_controls_section(
			'icon_box_style',
			[
				'label' => esc_html__( 'Workflow Box Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'Box-Style',
			[
				'label' => esc_html__( 'Left Workflow Box Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-content' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Box-right-Style',
			[
				'label' => esc_html__( 'Right Workflow Box Style', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-item-wrap' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
        
		$this->start_controls_section(
			'icon_style',
			[
				'label' => esc_html__( 'Icon Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'sub_margin',
			[
				'label' => esc_html__( 'List Icon Margin', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-item .item-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
       
        $this->add_control(
			'icon-size',
			[
				'label' => esc_html__( 'Icon Size', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-item .item-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-item .item-icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__( 'Icon BG Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-item .item-icon' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

		
		$this->start_controls_section(
			'slider_sub_title_style',
			[
				'label' => esc_html__( 'Title Style', 'fladient-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'ttl_margin',
			[
				'label' => esc_html__( 'Title Margin', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-item .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Sub Title Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-item .item-title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Border Color', 'fladient-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fd-workflow-2-item .item-title-line' => 'background: {{VALUE}}',
				],
			]
		);
		// typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'm_s_typography',
				'selector' => '{{WRAPPER}} .fd-workflow-2-item .item-title',
			]
		);


		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/workflow/workflow-1.php';
    }


}


Plugin::instance()->widgets_manager->register( new Fladient_Workflow() );