<?php
/*
 * Theme Metabox
 * @package fladient-tools
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {

    $prefix = 'fladient';

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'fladient_page_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Page Options',
        'post_type' => array('plan', 'page', 'post'),
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Header Option', 'fladient-tools' ),
            ),

            array(
				'id'       => 'meta_header_type',
				'type'     => 'switcher',
				'title'    => __( 'Header Style', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => false
			),
            array(
				'id'          => 'meta_header_style',
				'type'        => 'select',
				'title'       => __('Select Header Style', 'fladient-plugin' ),
				'options'     => fladient_Plugin_Helper::get_header_types(),
                'dependency' => array( 'meta_header_type', '==', 'true' ),
			),
            array(
				'id'       => 'page_header_disable',
				'type'     => 'switcher',
				'title'    => __( 'DIsable This page Header?', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => false
			),
        ),
    ) );

    CSF::createSection( $post_metabox, array(
        'title'  => 'Page Breadcrumb',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Page Breadcrumb', 'fladient-tools' ),
            ),
            array(
				'id'       => 'enable_page_preadcrumb',
				'type'     => 'switcher',
				'title'    => __( 'Page Breadcrumb', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => true
			),
            array(
				'id'       => 'hide_bg_img',
				'type'     => 'switcher',
				'title'    => __( 'Hide Breadcrumb Page Image', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => true
			),
            array(
                'id'    => 'bg_img_from_page',
                'type'  => 'media',
                'title' => esc_html__( 'Page Breadcrumb Background Image', 'fladient-tools' ),
                'dependency' => array( 'enable_page_preadcrumb', '==', 'true' ),
                
            ),
            array(
				'id'       => 'enable_custom_title',
				'type'     => 'switcher',
				'title'    => __( 'Enable Page Custom Title', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => false
			),
            
            array(
                'id'    => 'page_custom_title',
                'type'  => 'text',
                'title' => esc_html__( 'Page Custom Title', 'fladient-tools' ),
                'dependency' => array( 'enable_custom_title', '==', 'true' ),
            ),
            
        )
    ) );

    CSF::createSection( $post_metabox, array(
        'title'  => 'Page Style',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Page Style', 'fladient-tools' ),
            ),
            array(
                'id'     => 'scroll-bar',
                'type'   => 'color',
                'title'  => 'Page Scroll Bar Color',
                'output'      => 'body::-webkit-scrollbar-thumb',
                'output_mode' => 'background',
            ),
            array(
                'id'     => 'scroll-up',
                'type'   => 'color',
                'title'  => 'Page Scroll UP BUtton Color',
                'output'      => '.scroll-top',
                'output_mode' => 'background',
            ),
            array(
                'id'     => 'border-up',
                'type'   => 'color',
                'title'  => 'Breadcrumb Border Color',
                'output'      => '.feh-breadcrumb-area',
                'output_mode' => 'border-color',
            ),
            
            
        )
    ) );
    

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Footer',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Option', 'fladient-tools' ),
            ),

            array(
				'id'       => 'meta_footer_type',
				'type'     => 'switcher',
				'title'    => __( 'Footer Style', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => false
			),
            array(
				'id'          => 'meta_footer_style',
				'type'        => 'select',
				'title'       => __('Select Footer Style', 'fladient-plugin' ),
				'options'     => fladient_Plugin_Helper::get_footer_types(),
                'dependency' => array( 'meta_footer_type', '==', 'true' ),
			),
            array(
				'id'       => 'page_footer_disable',
				'type'     => 'switcher',
				'title'    => __( 'DIsable This page Footer?', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => false
			),

        ),
    ) );

     /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'fladient_pricing_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Pricing Options',
        'post_type' => 'fladient_pricing',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'fladient Pricing Table ',
        'fields' => array(
            array(
                'id'      => 'populer_item',
                'type'    => 'checkbox',
                'title'   => 'Select Populer Item',
                'label'   => 'If you want to Populer Item then please check the box',
                'default' => false // or false
            ),
            array(
                'id'    => 'offer_text',
                'type'  => 'text',
                'title' => esc_html__( 'Offer Text', 'fladient-tools' ),
            ),
            array(
                'id'    => 'currency',
                'type'  => 'text',
                'title' => esc_html__( 'Currency', 'fladient-tools' ),
                'default' => '$',
            ),
            array(
                'id'    => 'monthly_price',
                'type'  => 'text',
                'title' => esc_html__( 'Monthly Price ', 'fladient-tools' ),
            ),
            array(
                'id'    => 'yearly_price',
                'type'  => 'text',
                'title' => esc_html__( 'Yearly Price ', 'fladient-tools' ),
            ),
            array(
                'id'    => 'mon_period',
                'type'  => 'text',
                'title' => esc_html__( 'Monthly Period ', 'fladient-tools' ),
                'default' => esc_html__( '/ Monthly', 'fladient-tools' ),
            ),
            array(
                'id'    => 'yr_period',
                'type'  => 'text',
                'title' => esc_html__( 'Yearly Period ', 'fladient-tools' ),
                'default' => esc_html__( '/ Yearly', 'fladient-tools' ),
            ),
            array(
                'id'         => 'pricing_lists',
                'type'       => 'group',
                'title'      => 'Add Pricing List Item',
                'fields'     => array(
                    
                    array(
                        'id'    => 'list-item',
                        'type'  => 'text',
                        'title' => esc_html__( 'Pricing List Item', 'fladient-tools' ),
                    ),
                    array(
                        'id'      => 'exclude-in-package',
                        'title'   => esc_html__( 'Exclude In This Package', 'fladient-tools' ),
                        'type'    => 'switcher',
                        'default' => false,
                    ),
                )

            ),
            array(
                'id'    => 'pricing_btn',
                'type'  => 'link',
                'title' => esc_html__( 'Pricing Button', 'fladient-tools' ),
            ),
            array(
                'id'    => 'pricing_txt',
                'type'  => 'text',
                'title' => esc_html__( 'Pricing Text', 'fladient-tools' ),
            ),

        ),
    ) );

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'fladient_career_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Career Options',
        'post_type' => 'fladient_career',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'fields' => array(
            
            array(
                'id'    => 'icon',
                'type'  => 'icon',
                'title' => esc_html__( 'Job Icon', 'fladient-tools' ),
            ),
           
            array(
                'id'    => 'job_type',
                'type'  => 'text',
                'title' => esc_html__( 'Job Type', 'fladient-tools' ),
                'desc' => esc_html__( 'Job Type Means Full Time Job or Part Time Job', 'fladient-tools' ),
            ),
            array(
                'id'    => 'job_location',
                'type'  => 'text',
                'title' => esc_html__( 'Job Location', 'fladient-tools' ),
                'desc' => esc_html__( 'Type Yor Job Location', 'fladient-tools' ),
            ),
            array(
                'id'    => 'job_date',
                'type'  => 'date',
                'title' => esc_html__( 'Job Date', 'fladient-tools' ),
                'desc' => esc_html__( 'Type Yor Job Ending Date Here', 'fladient-tools' ),
            ),
            array(
                'id'    => 'job_salary',
                'type'  => 'text',
                'title' => esc_html__( 'Job Salary', 'fladient-tools' ),
                'desc' => esc_html__( 'Type Yor Job Salary Range Here', 'fladient-tools' ),
            ),
            array(
                'id'    => 'job_excerpt',
                'type'  => 'textarea',
                'title' => esc_html__( 'Job Excerpt', 'fladient-tools' ),
                'desc' => esc_html__( 'Type Yor Job Short Description Here', 'fladient-tools' ),
            ),
        ),
    ) );



    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $fladient_temp_meta = 'fladient_temp_meta';

    CSF::createMetabox( $fladient_temp_meta, array(
        'title'     => 'Template Type',
        'post_type' => array('fladient_template'),
        'data_type' => 'unserialize'
    ) );

     // Header Section
     CSF::createSection( $fladient_temp_meta, array(
        'fields' => array(
            array(
                'id'          => 'fladient_template_type',
                'type'        => 'select',
                'title'       => 'Select Template Type',
                'placeholder' => 'Select Template Type',
                'options'     => array(
                  'tf_header_key'  => 'Header',
                  'tf_footer_key'  => 'Footer',
                ),
                'default'     => ''
            ),
        ),
    ) );


    /*-------------------------------------
    Portfolio Options
    -------------------------------------*/
    $fladient_port_meta = 'fladient_portfolio_meta';

    CSF::createMetabox( $fladient_port_meta, array(
        'title'     => 'Portfolio Option',
        'post_type' => array('fladient_portfolio'),
    ) );

     // Header Section
     CSF::createSection( $fladient_port_meta, array(
        'fields' => array(
            array(
                'id'          => 'port-column',
                'type'        => 'select',
                'title'       => 'Select Portfolio Column',
                'options'     => array(
                  '12'  => 'Full Column',
                  '6'   => 'Two Column',
                  '3'   => 'Four Column',
                  '4'   => 'Three Column',
                ),
                'default'     => '12'
            ),
            array(
                'id'    => 'cl_no',
                'type'  => 'text',
                'title' => esc_html__( 'Job Salary', 'fladient-tools' ),
                'desc' => esc_html__( 'Type Yor Job Salary Range Here', 'fladient-tools' ),
            ),
        ),
    ) );


    
    

} //endif
