<?php
/*
 * Theme Options
 * @package fladient
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {

    //
    // Set a unique slug-like ID
    $prefix = 'fladient';

    //
    // Create options
    CSF::createOptions( $prefix . '_theme_options', array(
        'menu_title'         => 'fladient Option',
        'menu_slug'          => 'fladient-theme-option',
        'menu_type'          => 'menu',
        'enqueue_webfont'    => true,
        'show_in_customizer' => true,
        'menu_icon' => 'dashicons-category',
        'menu_position' => 50,
        'theme'                   => 'dark',
        'framework_title'    => wp_kses_post( 'Haptic Options <small>by Raziul <br/> Version: 1.0</small> ' ),
        'footer_text'    => wp_kses_post( 'The Theme will Created By Themexriver ' ),
    ) );

    // Create a top-tab
    CSF::createSection( $prefix . '_theme_options', array(
        'id'    => 'header_opts', // Set a unique slug-like ID
        'title' => 'Header',
    ) );


    /*-------------------------------------------------------
     ** Logo Settings  Options
    --------------------------------------------------------*/

    /*-------------------------------------------------------
     ** Header  Options
    --------------------------------------------------------*/

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'General Settings',
        'id'     => 'general_settings',
        'icon'   => 'fa fa-refresh',
        'fields' => array(

            array(
                'id'      => 'preloader_enable',
                'title'   => esc_html__( 'Enable Preloader', 'fladient-tools' ),
                'type'    => 'switcher',
                'desc'    => esc_html__( 'Enable or Disable Preloader', 'fladient-tools' ),
                'default' => true,
            ),
            
            array(
                'id'      => 'fladient_custom_preloader',
                'title'   => esc_html__( 'Upload Loader Logo', 'fladient-tools' ),
                'type'    => 'media',
                'desc'    => esc_html__( 'If you Want to Upload Svg or png logo for preloader? them at first remove preloader logo text and then upload logo here', 'fladient-tools' ),
                'dependency' => array( 
                    'preloader_enable', '==', 'true',
                ),
            ),
            array(
                'id'      => 'scroll_up_btn',
                'title'   => esc_html__( 'Scroll Up SHOW/HIDE', 'fladient-tools' ),
                'type'    => 'switcher',
                'desc'    => esc_html__( 'Enable or Disable Scroll UP', 'fladient-tools' ),
                'default' => true,
            ),

        ),
    ) );

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Header', 'fladient-tools' ),
        'parent'     => 'header_opts',
        'icon'   => 'fa fa-header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Header Layout', 'fladient-tools' ) . '</h3>',
            ),

            array(
                'id'          => 'header_style',
                'type'        => 'select',
                'title'       => __('Select Header Style', 'fladient-tools' ),
                'options'     => fladient_Plugin_Helper::get_header_types(),
            ), 
            array(
                'id'      => 'fladient_logo',
                'title'   => esc_html__( 'Default Logo', 'fladient-tools' ),
                'type'    => 'media',
                'desc'    => esc_html__( 'Upload Logo', 'fladient-tools' ),
                'default' => true,
            ),
           
        ),
    ) );

    
    /*-------------------------------------
     ** Typography Options
    -------------------------------------*/
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Typography', 'fladient-tools' ),
        'id'     => 'typography_options',
        'icon'   => 'fa fa-font',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Body', 'fladient-tools' ) . '</h3>',
            ),

            array(
                'id'     => 'body-typography',
                'type'   => 'typography',
                'output' => 'body',

            ),

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Heading', 'fladient-tools' ) . '</h3>',
            ),

            array(
                'id'     => 'heading-gl-typo',
                'type'   => 'typography',
                'output' => 'h1, h2, h3, h4, h5, h6',
            ),

        ),
    ) );

    // Product
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Woocommerce Option', 'fladient-tools' ),
        'id'     => 'woo_option',
        'icon'   => 'fa fa-header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Woocommerce Option', 'fladient-tools' ) . '</h3>',
            ),

            array(
                'id'      => 'product_count',
                'title'   => esc_html__( 'Product Count', 'fladient-tools' ),
                'type'    => 'text',
                'default' => '12',
            ),
            array(
				'id'       => 'enable_shop_preadcrumb',
				'type'     => 'switcher',
				'title'    => __( 'Page Breadcrumb', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => true
			),
            array(
                'id'      => 'shop_breadcrumb_bg',
                'title'   => esc_html__( 'Shop Breadcrumb BG', 'fladient-tools' ),
                'type'    => 'media',
                'dependency' => array( 'enable_shop_preadcrumb', '==', 'true' ),
            ),
            array(
                'id'      => 'shop_breadcrumb_title',
                'title'   => esc_html__( 'Shop Breadcrumb Title', 'fladient-tools' ),
                'type'    => 'text',
                'dependency' => array( 'enable_shop_preadcrumb', '==', 'true' ),
            ),
            array(
				'id'       => 'enable_single_product_preadcrumb',
				'type'     => 'switcher',
				'title'    => __( 'Shop Enable Breadcrumb', 'fladient-plugin' ),
				'text_on'  => __( 'Yes', 'fladient-plugin' ),
				'text_off' => __( 'No', 'fladient-plugin' ),
				'default'  => true
			),
            array(
                'id'      => 'product_single_breadcrumb_bg',
                'title'   => esc_html__( 'Product Single Breadcrumb BG', 'fladient-tools' ),
                'type'    => 'media',
                'dependency' => array( 'enable_single_product_preadcrumb', '==', 'true' ),
            ),
            array(
                'id'      => 'product_single_breadcrumb_title',
                'title'   => esc_html__( 'Shop Breadcrumb Title', 'fladient-tools' ),
                'type'    => 'text',
                'dependency' => array( 'enable_single_product_preadcrumb', '==', 'true' ),
            ),
           
        ),
    ) );

    // blog optoins
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Breadcrumb', 'fladient-tools' ),
        'id'     => 'blog_page',
        'icon'   => 'fa fa-rss-square',
        'fields' => array(
            array(
                'id'      => 'breadcrumb_bg_img',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb BG', 'fladient-tools'),
            ),
            array(
                'id'    => 'page_desc_desc',
                'type'  => 'textarea',
                'title' => esc_html__( 'Page Description', 'fladient-tools' ),
                'default' => esc_html__( 'Seamlessly connect with your tools and streamline workflows to enhance efficiency and performance.', 'fladient-tools' )
            ),
            array(
                'id'       => 'br_btn_link',
                'type'     => 'link',
                'title'    => 'Button',
                'default'  => array(
                  'url'    => 'themexriver.com',
                  'text'   => 'Discover More',
                  'target' => '_blank'
                ),
            ),
            array(
                'id'    => 'img_1',
                'type'  => 'media',
                'title' => esc_html__( 'Image One', 'fladient-tools' ),
            ),
            array(
                'id'    => 'img_2',
                'type'  => 'media',
                'title' => esc_html__( 'Image Two', 'fladient-tools' ),
            ),
            array(
                'id'    => 'img_3',
                'type'  => 'media',
                'title' => esc_html__( 'Image Three', 'fladient-tools' ),
            ),
            array(
                'id'    => 'img_4',
                'type'  => 'media',
                'title' => esc_html__( 'Image Four', 'fladient-tools' ),
            ),
        ),
    ) );

    // blog optoins
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Blog', 'fladient-tools' ),
        'id'     => 'blog_page',
        'icon'   => 'fa fa-rss-square',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Blog Options', 'fladient-tools' ) . '</h3>',
            ),
            
            array(
                'id'      => 'br_custom_title',
                'type'    => 'text',
                'title'   => esc_html__('Blog Breadcrumb Title', 'fladient-tools'),
                'desc'    => esc_html__('If you Do not Blog Breadcrumb Custom Title then type Title Here', 'fladient-tools'),
            ),
            array(
                'id'      => 'breadcrumb_bg',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb BG', 'fladient-tools'),
            ),
            
            array(
                'id'      => 'blog_btn_text',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Read More Button', 'fladient-tools' ),
                'default' => esc_html__( 'Explore More', 'fladient-tools' ),
                'desc'    => esc_html__( 'Type Blog Read More Button Text Here', 'fladient-tools' ),
            ),
        ),
    ) );
    

   // fladient Color Setting
   CSF::createSection( $prefix . '_theme_options', array(
    'title'  => 'Color Control',
    'id'     => 'apix_color_control',
    'icon'   => 'fa fa-paint-brush',
    'fields' => array(
        

        array(  //nav bar one start
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Theme Global Color', 'fladient-tools' ) . '</h3>',
        ),
        array(
            'id'    => 'theme-color-1',
            'type'  => 'color',
            'title' => 'Theme Primary Color',
            'default' => '#fc4827'
        ),
        array(
            'id'    => 'theme-color-2',
            'type'  => 'color',
            'title' => 'Theme Secondary Color',
            'default' => '#ff392c'
        ),
        array(
            'id'    => 'theme-color-3',
            'type'  => 'color',
            'title' => 'Theme Third Color',
            'default' => '#ef991f'
        ),
        
        
    ),
) );

    // Create a section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'Error Page',
        'id'     => 'error_page',
        'icon'   => 'fa fa-exclamation-triangle',
        'fields' => array(
            

            array(  //nav bar one start
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( '404 Page Options', 'fladient-tools' ) . '</h3>',
            ),
            
            array(
                'id'      => 'error_code',
                'type'    => 'media',
                'title'   => esc_html__( 'Error Code Image', 'fladient-tools' ),
            ),
            array(
                'id'      => 'error_title',
                'type'    => 'text',
                'title'   => esc_html__( '404 Title', 'fladient-tools' ),
                'default' => esc_html__( 'Oops! Page Not found.', 'fladient-tools' ),
            ),
           
            array(
                'id'      => 'error_button',
                'type'    => 'text',
                'title'   => esc_html__( '404 Button', 'fladient-tools' ),
                'default' => esc_html__( 'back to Home page ', 'fladient-tools' ),
            )

                     
        ),
    ) );

    /*-------------------------------------------------------
     ** Footer  Options
    --------------------------------------------------------*/
    
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Footer Options', 'fladient-tools' ),
        'icon'   => 'fa fa-copyright',
        'fields' => array(

            array(
                'id'          => 'footer_style',
                'type'        => 'select',
                'title'       => __('Select Footer Style', 'fladient-tools' ),
                'options'     => fladient_Plugin_Helper::get_footer_types(),
            ),     
            array(
                'id'    => 'footer_copyright',
                'type'  => 'wp_editor',
                'title' => 'Default Footer Copyright',
                'default' => '© 2023 fladient - IT Services. All rights reserved.',
            ),

        ),
    ) );

    // Backup section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Backup Export', 'fladient-tools' ),
        'id'     => 'backup_options',
        'icon'   => 'fa fa-window-restore',
        'fields' => array(
            array(
                'type' => 'backup',
            ),
        ),
    ) );




}