<?php 

if ( !function_exists( 'fladient_tour_type_tax' ) ) {
    function fladient_tour_type_tax() {
        $labels = [
            'name'          => esc_html__( 'Tour Type', 'fladient-plugin' ),
            'menu_name'     => esc_html__( 'Tour Type', 'fladient-plugin' ),
            'singular_name' => esc_html__( 'Tour Type', 'fladient-plugin' ),
            'search_items'  => esc_html__( 'Search Type', 'fladient-plugin' ),
            'all_items'     => esc_html__( 'All Type', 'fladient-plugin' ),
            'new_item_name' => esc_html__( 'New Type', 'fladient-plugin' ),
            'add_new_item'  => esc_html__( 'Add New Type', 'fladient-plugin' ),
            'edit_item'     => esc_html__( 'Edit New Type', 'fladient-plugin' ),
            'update_item'   => esc_html__( 'Update New Type', 'fladient-plugin' ),
        ];
        $args = array(
            'labels'                => $labels,
            'hierarchical'          => true,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'query_var'             => true,
            'update_count_callback' => '_update_post_term_count',
        );
        register_taxonomy('tour_type', 'at_biz_dir', $args);
    }
    add_action( 'init', 'fladient_tour_type_tax' );
}