<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package fladient
 */

get_header();
$error_code = cs_get_option('error_code');
$error_title = cs_get_option('error_title');
$error_button = cs_get_option('error_button');
?>
<div class="feh-oops-area fix">
	<div class="container">
		<div class="feh-oops-wrap text-center">
			<div class="img-wrap">
				<img class="feh-img-plx" data-value="4" src="<?php if (!empty($error_code['url'])) {
					echo esc_url($error_code['url']);
				} else {
					echo esc_url(get_template_directory_uri() . '/assets/img/oops.svg');
				} ?>"
					alt="<?php esc_attr_e('404', 'fladient'); ?>" />
			</div>
			<h3 class="ftc-heading-1 title">
				<?php if (!empty($error_title)) {
					echo esc_html($error_title);
				} else {
					esc_html_e('Oops! Page Not found.', 'fladient');
				} ?>	
			</h3>
			<div class="back-btn-wrap">
				<a href="<?php echo esc_url(home_url('/')); ?>" aria-label="name" class="fd-pr-btn-1 text-capitalize has-clr-black-1">
					<span class="text" data-back="<?php if (!empty($error_button)) {
							echo esc_html($error_button);
						} else {
							esc_html_e('Go Back Home', 'fladient');
						} ?>" data-front="<?php if (!empty($error_button)) {
							echo esc_html($error_button);
						} else {
							esc_html_e('Go Back Home', 'fladient');
						} ?>"></span>
				</a>
			</div>
		</div>
	</div>
</div>


<?php
get_footer();
