<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package fladient
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
	return;
}
?>

<div id="comments" class="blog-details-comments-wrap mb-40">

	<?php
	// You can start editing here -- including this comment!
	if (have_comments()):
		?>
		<div class="post-comments">
			<h5 class="comments-title ftc-heading-1">
				<?php
				$fladient_comment_count = get_comments_number();
				if ('1' === $fladient_comment_count) {
					printf(
						/* translators: 1: title. */
						esc_html__('1 Comment', 'fladient'),
						'<span>' . wp_kses_post(get_the_title()) . '</span>'
					);
				} else {
					printf(
						/* translators: 1: comment count number, 2: title. */
						esc_html(_nx('%1$s Comment', '%1$s Comments', $fladient_comment_count, 'comments title', 'fladient')),
						number_format_i18n($fladient_comment_count), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						'<span>' . wp_kses_post(get_the_title()) . '</span>'
					);
				}
				?>
			</h5><!-- .comments-title -->
			<?php the_comments_navigation(); ?>
			<div class="comments-box-wrap mb-20">
				<ol class="comment-list list-unstyled mb-0">
					<?php
					wp_list_comments(
						array(
							'callback' => 'fladient_comments'
						)
					);
					?>
				</ol><!-- .comment-list -->
			</div>


		</div>
		<?php
		the_comments_navigation();

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if (!comments_open()):
			?>
			<p class="no-comments">
				<?php esc_html_e('Comments are closed.', 'fladient'); ?>
			</p>
			<?php
		endif;

	endif; // Check for have_comments().
	?>
</div><!-- #comments -->
<?php
$args = array(
	'comment_notes_after' => '<button type="submit" aria-label="name" class="fd-pr-btn-1 text-capitalize has-clr-black-1">
		<span class="text" data-back="' . esc_attr('Post Comment') . '" data-front="' . esc_attr('Post Comment') . '"></span>
	</button> '

);
comment_form($args);
?>