<?php
/**
 * fladient functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package fladient
 */

define('FLADIENT_THEME_DRI', get_template_directory());
define('FLADIENT_INC_DRI', get_template_directory() . '/inc/');
define('FLADIENT_THEME_URI', get_template_directory_uri());
define('FLADIENT_CSS_PATH', FLADIENT_THEME_URI . '/assets/css');
define('FLADIENT_JS_PATH', FLADIENT_THEME_URI . '/assets/js');
define('FLADIENT_IMG_PATH', FLADIENT_THEME_URI . '/assets/images');
define('FLADIENT_ADMIN_DRI', FLADIENT_THEME_DRI . '/admin');

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function fladient_setup(){
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on fladient, use a find and replace
	 * to change 'fladient' to the name of your theme in all the template files.
	 */
	load_theme_textdomain('fladient', get_template_directory() . '/languages');

	// Add default posts and comments RSS feed links to head.
	add_theme_support('automatic-feed-links');
	add_image_size('fladient-img-size-1', 435, 323, true);
	add_image_size('fladient-img-size-2', 733, 465, true);
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support('title-tag');
	remove_theme_support('widgets-block-editor');
	add_filter( 'big_image_size_threshold', '__return_false' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support('post-thumbnails');

	//Woocommerc
	add_theme_support('woocommerce');
	add_theme_support('wc-product-gallery-lightbox');
	add_theme_support('wc-product-gallery-slider');

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__('Primary', 'fladient'),
		)
	);

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'fladient_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support('customize-selective-refresh-widgets');

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height' => 250,
			'width' => 250,
			'flex-width' => true,
			'flex-height' => true,
		)
	);
}
add_action('after_setup_theme', 'fladient_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function fladient_content_width(){
	$GLOBALS['content_width'] = apply_filters('fladient_content_width', 640);
}
add_action('after_setup_theme', 'fladient_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function fladient_widgets_init(){
	register_sidebar(
		array(
			'name' => esc_html__('Sidebar', 'fladient'),
			'id' => 'sidebar-1',
			'description' => esc_html__('Add widgets here.', 'fladient'),
			'before_widget' => '<div id="%1$s" class="%2$s fd-blog-page-sidebar-widget mb-30 wow fadeInUp">',
			'after_widget' => '</div>',
			'before_title' => '<h6 class="fd-heading-1 fd-font-600 widget-title">',
			'after_title' => '</h6>',
		)
	);
	register_sidebar(
		array(
			'name' => esc_html__('Shop Siderbar', 'fladient'),
			'id' => 'shop-sidebar-1',
			'description' => esc_html__('Add widgets here.', 'fladient'),
			'before_widget' => '<div id="%1$s" class="widget mt-30 %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h2 class="widget__title">',
			'after_title' => '</h2>',
		)
	);
}
add_action('widgets_init', 'fladient_widgets_init');



/**
 *Google Font Load 
 */
if (!function_exists('fladient_fonts_url')):

	function fladient_fonts_url(){
		$fonts_url = '';
		$font_families = array();
		$subsets = 'latin';

		if ('off' !== _x('on', 'Urbanist: on or off', 'fladient')) {
			$font_families[] = 'Urbanist:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
		}
		if ('off' !== _x('on', 'Unbounded: on or off', 'ftech')) {
			$font_families[] = 'Unbounded:200,300,400,500,600,700,800,900';
		}
		
		if ($font_families) {
			$fonts_url = add_query_arg(
				array(
					'family' => urlencode(implode('|', $font_families)),
					'subset' => urlencode($subsets),
				),
				'https://fonts.googleapis.com/css'
			);
		}

		return esc_url_raw($fonts_url);
	}
endif;


/**
 * Enqueue scripts and styles.
 */
function fladient_scripts(){

	wp_enqueue_style('fladient-google-fonts', fladient_fonts_url(), array(), null);

	wp_enqueue_style('bootstrap', FLADIENT_CSS_PATH . '/bootstrap.min.css');
	wp_enqueue_style('all-min', FLADIENT_CSS_PATH . '/all.min.css');
	wp_enqueue_style('e-animations', FLADIENT_CSS_PATH . '/animate.css');
	wp_enqueue_style('flaticon-one', FLADIENT_CSS_PATH . '/flaticon_fd-icon.css');
	wp_enqueue_style('magnific-popup', FLADIENT_CSS_PATH . '/magnific-popup.css');
	wp_enqueue_style('swiper-fladient', FLADIENT_CSS_PATH . '/swiper.min.css');
	wp_enqueue_style('pagepiling', FLADIENT_CSS_PATH . '/pagepiling.css');
	wp_enqueue_style('fladient-main', FLADIENT_CSS_PATH . '/main.css');

	if (class_exists('WooCommerce')) {
		wp_enqueue_style('woocommerce-style', get_template_directory_uri() . '/woocommerce/woocommerce.css');
	}

	$your_curnt_lang = apply_filters('wpml_current_language', NULL);
	if (is_rtl() && $your_curnt_lang != 'en') {
		wp_enqueue_style('fladient-rtl', FLADIENT_CSS_PATH . '/rtl.css');
	}

	wp_enqueue_style('fladient-style', get_stylesheet_uri(), array());

	wp_enqueue_script( 'imagesloaded', ['jquery'], false, true );
    wp_enqueue_script( 'jquery-ui-core', ['jquery'], false, true );
	wp_enqueue_script('bootstrap-bundle', FLADIENT_JS_PATH . '/bootstrap.bundle.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('swiper-bundle', FLADIENT_JS_PATH . '/swiper-bundle.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('wow', FLADIENT_JS_PATH . '/wow.js', array('jquery'), '1.0', true);
	wp_enqueue_script('CustomEase', FLADIENT_JS_PATH . '/CustomEase.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('magnific-popup', FLADIENT_JS_PATH . '/magnific-popup.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('SplitText', FLADIENT_JS_PATH . '/SplitText.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('gsap', FLADIENT_JS_PATH . '/gsap.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('counterup', FLADIENT_JS_PATH . '/counterup.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('marquee', FLADIENT_JS_PATH . '/marquee.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('waypoints', FLADIENT_JS_PATH . '/waypoints.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('lenis', FLADIENT_JS_PATH . '/lenis.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('ScrollTrigger', FLADIENT_JS_PATH . '/ScrollTrigger.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('pagepiling', FLADIENT_JS_PATH . '/pagepiling.js', array('jquery'), '1.0', true);
	
	wp_enqueue_script('fladient-main', FLADIENT_JS_PATH . '/main.js', array('jquery'), '1.0', true);

	$your_curnt_lang = apply_filters('wpml_current_language', NULL);
	if (is_rtl() && $your_curnt_lang != 'en') {
		wp_enqueue_script('fladient-rtl', FLADIENT_JS_PATH . '/rtl.js', array('jquery'), '1.0', true);
	}


	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'fladient_scripts');

/**
 * Implement the Custom Header feature.
 */
require FLADIENT_THEME_DRI . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require FLADIENT_THEME_DRI . '/inc/template-tags.php';

/**
 * Custom template tags for this theme.
 */
require FLADIENT_THEME_DRI . '/inc/class-wp-fladient-navwalker.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require FLADIENT_THEME_DRI . '/inc/template-functions.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require FLADIENT_THEME_DRI . '/inc/fladient-functions.php';

/**
 * Cs Fremwork Config
 */
require FLADIENT_THEME_DRI . '/inc/cs-framework-functions.php';

/**
 * Dynamic Style
 */
require FLADIENT_THEME_DRI . '/inc/dynamic-style.php';

/**
 * fladient Core Functions
 */
require FLADIENT_THEME_DRI . '/inc/fladient-helper-class.php';

/**
 * fladient Core Functions
 */
require FLADIENT_THEME_DRI . '/inc/admin/class-admin-dashboard.php';

/**
 * fladient Core Functions
 */
require FLADIENT_THEME_DRI . '/inc/admin/demo-import/functions.php';

/**
 * Customizer additions.
 */
require FLADIENT_THEME_DRI . '/inc/customizer.php';


/**
 * Initial Breadcrumb
 */
require FLADIENT_THEME_DRI . '/inc/breadcrumb-init.php';



/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
	require FLADIENT_THEME_DRI . '/inc/jetpack.php';
}

