<?php

/**
 * [fladient_Admin description]
 */
if (!class_exists('fladient_Admin')) {
    class fladient_Admin{

        private static $instance = null;

        /**
         * register instance
         *
         * @return void
         */
        public static function init(){
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        /**
         * init Construct
         */
        public function __construct(){
            add_action('init', [$this, 'fladient_tgm_dashboard'], 1);
            add_action('admin_menu', [$this, 'fladient_admin_dashboard'], 1);
            add_action('admin_menu', [$this, 'fladient_template_dashboard'], 20);
            add_action('ocdi/plugin_page_setup', [$this, 'fladient_import_dsb'], 20);
            add_action('admin_enqueue_scripts', array($this, 'fladient_Admin_enqueue_scripts'));
        }

        /**
         * Admin Dashboard
         *
         * @return void
         */
        public function fladient_admin_dashboard(){
            add_menu_page(
                esc_html__('fladient', 'fladient'),
                esc_html__('fladient', 'fladient'),
                'manage_options',
                'fladient',
                [$this, 'display_fladient_admin_dashboard'],
                get_template_directory_uri() . '/inc/admin/assets/img/favicon.png',
                2
            );


        }

        /**
         * Template Dashboard
         *
         * @return void
         */
        public function fladient_template_dashboard() {
            add_submenu_page(
                'fladient',
                esc_html__('Templates', 'fladient'),
                esc_html__('Templates', 'fladient'),
                'manage_options',
                'edit.php?post_type=fladient_template',
                false
            );
        }

        /**
         * admin style Add
         */
        public function fladient_Admin_enqueue_scripts()
        {
            wp_enqueue_style('fladient-admin', get_theme_file_uri('inc/admin/assets/css/admin.css'), array(), null, 'all');
        }

        public function display_fladient_admin_dashboard()
        {
            require_once FLADIENT_INC_DRI . 'admin/admin-page.php';
        }

        public function fladient_tgm_dashboard()
        {
            require_once FLADIENT_INC_DRI . 'admin/class-tgm-plugin-activation.php';
            require_once FLADIENT_INC_DRI . 'admin/plugin-activation.php';
        }

        public function fladient_import_dsb($default)
        {
            $default['parent_slug'] = 'fladient';
            $default['page_title'] = esc_html__('One Click Demo Import', 'fladient');
            $default['menu_title'] = esc_html__('Import Demo Data', 'fladient');
            $default['capability'] = 'import';
            $default['menu_slug'] = 'one-click-demo-import';

            return $default;
        }
    }
    fladient_Admin::init();
}
