<?php

/**
 * [fladient_breadcrumb description]
 * @return [type] [description]
 */
function fladient_breadcrumb(){

	$wpbreadcrumb_class = '';
	$breadcrumb_show = 1;

	$id = get_the_ID();

	if (is_front_page() && is_home()) {
		$title = get_the_title();
		$wpbreadcrumb_class = 'tx-front-page';
	} elseif (is_front_page()) {
		$title = get_the_title();
		$breadcrumb_show = 0;

	} elseif (is_home()) {
		if (get_option('page_for_posts')) {
			$id = get_option('page_for_posts');
			$title = get_the_title(get_option('page_for_posts'));
		}
	} elseif (is_single() && 'post' == get_post_type()) {
		$title = get_the_title();
	} elseif (is_search()) {
		$title = esc_html__('Search Results for : ', 'fladient') . get_search_query();
	} elseif (is_404()) {
		$title = esc_html__('Page not Found', 'fladient');
	} elseif (function_exists('is_woocommerce') && is_shop()) {
		$title = get_the_title(get_option('woocommerce_shop_page_id'));
	} elseif (function_exists('is_woocommerce') && is_product()) {
		$title = __('Product Details', 'fladient');
	} elseif (function_exists('is_woocommerce') && is_product_tag()) {
		$title = get_the_archive_title();
	} elseif (function_exists('is_woocommerce') && is_product_category()) {
		$title = get_the_archive_title();
	} elseif (is_archive()) {
		$title = get_the_archive_title();
	} else {
		$title = get_the_title();
	}

	// from page meta
	if (get_option('page_for_posts')) {
		$page_for_posts = get_queried_object_id();
		$page_for_posts_meta = get_post_meta($page_for_posts, 'fladient_page_meta', true) ? get_post_meta($page_for_posts, 'fladient_page_meta', true) : [];
	} else {
		$page_meta = get_post_meta($id, 'fladient_page_meta', true) ? get_post_meta($id, 'fladient_page_meta', true) : [];
	}

	if (get_option('page_for_posts')) {
		$enable_page_preadcrumb = array_key_exists('enable_page_preadcrumb', $page_for_posts_meta) ? $page_for_posts_meta['enable_page_preadcrumb'] : true;
	} else {
		$enable_page_preadcrumb = array_key_exists('enable_page_preadcrumb', $page_meta) ? $page_meta['enable_page_preadcrumb'] : true;
	}

	if (get_option('page_for_posts')) {
		$enable_bg_image = array_key_exists('enable_bg_image', $page_for_posts_meta) ? $page_for_posts_meta['enable_bg_image'] : true;
	} else {
		$enable_bg_image = array_key_exists('enable_bg_image', $page_meta) ? $page_meta['enable_bg_image'] : true;
	}

	if ($enable_page_preadcrumb == true && $breadcrumb_show == 1) {

		// from page meta
		if (get_option('page_for_posts')) {
			$bg_img_from_page = array_key_exists('bg_img_from_page', $page_for_posts_meta) ? $page_for_posts_meta['bg_img_from_page'] : '';
			$enable_custom_title = array_key_exists('enable_custom_title', $page_for_posts_meta) ? $page_for_posts_meta['enable_custom_title'] : false;
			$page_custom_title = array_key_exists('page_custom_title', $page_for_posts_meta) ? $page_for_posts_meta['page_custom_title'] : '';
		} else {
			$bg_img_from_page = array_key_exists('bg_img_from_page', $page_meta) ? $page_meta['bg_img_from_page'] : '';
			$enable_custom_title = array_key_exists('enable_custom_title', $page_meta) ? $page_meta['enable_custom_title'] : false;
			$page_custom_title = array_key_exists('page_custom_title', $page_meta) ? $page_meta['page_custom_title'] : '';
		}

		// from theme option
		$breadcrumb_bg = cs_get_option('breadcrumb_bg_img');
		$bg_img = !empty($breadcrumb_bg) ? $breadcrumb_bg['url'] : '';

		if ($enable_bg_image == false) {
			$bg_img = $bg_img;
		} else {
			$bg_img = !empty($bg_img_from_page['url']) ? $bg_img_from_page['url'] : $bg_img;
		}

		$shop_details_breadcrumb = is_single() && 'product' == get_post_type() ? ' no-breadcrumb-ttile' : '';
		$bg_url = !empty($bg_img) ? $bg_img : "";

		$title = $enable_custom_title == true ? $page_custom_title : $title;

		// check if front page
		if (is_front_page()) {
			$title = __('Blog', 'fladient');
		}

		if (has_nav_menu('main-menu')) {
			$no_menu_class = '';
		} else {
			$no_menu_class = ' pt-200';
		}
		$page_desc_desc = cs_get_option('page_desc_desc');
		$br_btn_link = cs_get_option('br_btn_link');
		$img_1 = cs_get_option('img_1');
		$img_2 = cs_get_option('img_2');
		$img_3 = cs_get_option('img_3');
		$img_4 = cs_get_option('img_4');
		?>

		<div class="breadcrumb-area p-relative  bg-default fix" data-background="<?php echo esc_url($bg_url); ?>">
			<div class="container fd-container-1">
                <div class="breadcrumb-wrap p-relative">

                    <div class="row align-items-end">
                        <!-- left -->
                        <div class="col-lg-6">
                            <!-- scn-title -->
                            <div class="breadcrumb-content ">
                                <h1 class="fd-scn-title-1 breadcrumb-content-title txaa-ani-subtitle-1 txaa-split-subtitle-1"><?php echo wp_kses_post($title); ?></h1>
								<?php if(!empty($page_desc_desc)):?>
                                <p class="fd-para-1 breadcrumb-content-disc  " fd-breadcrumb-s-d><?php echo fladient_wp_kses($page_desc_desc);?></p>
								<?php endif;?>
								<?php if(!empty($br_btn_link['text'])):?>
									<div class="breadcrumb-content-btn " fd-breadcrumb-s-d>
										<a href="<?php echo esc_url($br_btn_link['url']);?>" aria-label="name" class="fd-pr-btn-1 text-capitalize has-clr-black-1">
											<span class="text" data-back="<?php echo esc_attr($br_btn_link['text']);?>" data-front="<?php echo esc_attr($br_btn_link['text']);?>"></span>
										</a>
									</div>
								<?php endif;?>

                            </div>
                        </div>
    
                        <!-- right -->
                        <div class="col-lg-6">
                            <div class="breadcrumb-right p-relative  ">
								<?php if(!empty($img_1['url'])):?>
									<div class="breadcrumb-img " fd-breadcrumb-s-d>
										<img src="<?php echo esc_url($img_1['url']);?>" alt="">
									</div>
								<?php endif;?>
								<?php if(!empty($img_2['url'])):?>
									<div class="breadcrumb-illus-1" fd-breadcrumb-s-d>
										<img src="<?php echo esc_url($img_2['url']);?>" alt="">
									</div>
								<?php endif;?>
								<?php if(!empty($img_3['url'])):?>
									<div class="breadcrumb-illus-2" fd-breadcrumb-s-d>
										<img src="<?php echo esc_url($img_3['url']);?>" alt="">
									</div>
								<?php endif;?>
                            </div>
                        
                        </div>
                    </div>

                    <div class="breadcrumb-list" >
						<?php echo fladient_breadcrumb_callback(); ?>
                    </div>
                </div>

			</div>

			<?php if(!empty($img_4['url'])):?>
            	<img src="<?php echo esc_url($img_4['url']);?>" alt="" class="breadcrumb-shape">
			<?php endif;?>
			
		</div>
		<?php
	}
}
add_action('fladient_before_main_content', 'fladient_breadcrumb');

function fladient_breadcrumb_callback()
{
	global $wp_query;
	$queried_object = get_queried_object();
	$breadcrumb = '';
	$delimiter = '';
	$before = '';
	$after = '';
	if (!is_front_page()) {
		$breadcrumb .= $before . '<a href="' . home_url('/') . '">' . esc_html__('Home', 'fladient') . ' &nbsp;</a>' . $after;
		/** If category or single post */
		if (is_category()) {
			$cat_obj = $wp_query->get_queried_object();
			$this_category = get_category($cat_obj->term_id);
			if ($this_category->parent != 0) {
				$parent_category = get_category($this_category->parent);
				$breadcrumb .= get_category_parents($parent_category, true, $delimiter);
			}
			$breadcrumb .= $before . '<a href="' . get_category_link(get_query_var('cat')) . '">' . single_cat_title('', false) . '</a>' . $after;
		} elseif ($wp_query->is_posts_page) {
			$breadcrumb .='<span>' . $before . $queried_object->post_title . $after . '</span>';
		} elseif (is_tax()) {
			$breadcrumb .= $before . '<a href="' . get_term_link($queried_object) . '">' . $queried_object->name . '</a>' . $after;
		} elseif (is_page()) /** If WP pages */{
			global $post;
			if ($post->post_parent) {
				$anc = get_post_ancestors($post->ID);
				foreach ($anc as $ancestor) {
					$breadcrumb .= $before . '<a href="' . get_permalink($ancestor) . '">' . get_the_title($ancestor) . ' &nbsp;</a>' . $after;
				}
				$breadcrumb .= '<span>' . $before . '' . get_the_title($post->ID) . '' . $after . '</span>';
			} else {
				$breadcrumb .= '<span>' . $before . get_the_title() . $after . '</span>';
			}
		} elseif (is_singular()) {
			if ($category = wp_get_object_terms(get_the_ID(), array('category', 'location', 'tax_feature'))) {
				if (!is_wp_error($category)) {
					$breadcrumb .= $before . '<a href="' . get_term_link(binsro_set($category, '0')) . '">' . binsro_set(binsro_set($category, '0'), 'name') . '&nbsp;</a>' . $after;
					$breadcrumb .= '<span>' . $before . get_the_title() . $after . '</span>';
				} else {
					$breadcrumb .= '<span>' . $before . get_the_title() . $after . '</span>';
				}
			} else {
				$breadcrumb .= '<span>' . $before . get_the_title() . $after . '</span>';
			}
		} elseif (is_tag()) {
			$breadcrumb .= $before . '<a href="' . get_term_link($queried_object) . '">' . single_tag_title('', false) . '</a>' . $after;
		} /**If tag template*/elseif (is_day()) {
			$breadcrumb .= $before . '<a href="#">' . esc_html__('Archive for ', 'fladient') . get_the_time('F jS, Y') . '</a>' . $after;
		} /** If daily Archives */elseif (is_month()) {
			$breadcrumb .= $before . '<a href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . __('Archive for ', 'fladient') . get_the_time('F, Y') . '</a>' . $after;
		} /** If montly Archives */elseif (is_year()) {
			$breadcrumb .= $before . '<a href="' . get_year_link(get_the_time('Y')) . '">' . __('Archive for ', 'fladient') . get_the_time('Y') . '</a>' . $after;
		} /** If year Archives */elseif (is_author()) {
			$breadcrumb .= $before . '<a href="' . esc_url(get_author_posts_url(get_the_author_meta("ID"))) . '">' . __('Archive for ', 'fladient') . get_the_author() . '</a>' . $after;
		} /** If author Archives */elseif (is_search()) {
			$breadcrumb .= '<span>' . $before . '' . esc_html__('Search Results for ', 'fladient') . get_search_query() . '' . $after . '</span>';
		} /** if search template */elseif (is_404()) {
			$breadcrumb .= '<span>' . $before . '' . esc_html__('404 - Not Found', 'fladient') . '' . $after . '</span>';
			/** if search template */
		} elseif (is_post_type_archive('product')) {
			$shop_page_id = wc_get_page_id('shop');
			if (get_option('page_on_front') !== $shop_page_id) {
				$shop_page = get_post($shop_page_id);
				$_name = wc_get_page_id('shop') ? get_the_title(wc_get_page_id('shop')) : '';
				if (!$_name) {
					$product_post_type = get_post_type_object('product');
					$_name = $product_post_type->labels->singular_name;
				}
				if (is_search()) {
					$breadcrumb .= $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $delimiter . esc_html__('Search results for &ldquo;', 'fladient') . get_search_query() . '&rdquo;' . $after;
				} elseif (is_paged()) {
					$breadcrumb .= $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $after;
				} else {
					$breadcrumb .= '<span>' . $before . $_name . $after . '</span>';
				}
			}
		} else {
			$breadcrumb .= $before . '<a href="' . get_permalink() . '">' . wp_title() . '</a>' . $after;
		}
		/** Default value */
	}

	return $breadcrumb;
}
