<?php

// File Security Check
if (!defined('ABSPATH')) {
    exit;
}

function fladient_theme_options_style()
{

    //
    // Enqueueing StyleSheet file
    //
    wp_enqueue_style('fladient-theme-custom-style', get_template_directory_uri() . '/assets/css/custom-style.css');
    $css_output = '';
    $primery_color = cs_get_option('theme-color-1');
    $secondary_color = cs_get_option('theme-color-2');
    $third_color = cs_get_option('theme-color-3');
    

    /**
     * Theme Primery Global Color
     */
    if (!empty($primery_color)) {
        $css_output .= '       
        :root {
            --fd-clr-pr-1: ' . esc_attr($primery_color) . '
        }            
        ';
    }


    /**
     * Theme Heading Global Color
     */
    if (!empty($secondary_color)) {
        $css_output .= '       
        :root {
            --fd-clr-pr-2: ' . esc_attr($secondary_color) . '
        }            
        ';
    }

    /**
     * Theme Heading Global Color
     */
    if (!empty($third_color)) {
        $css_output .= '       
            :root {
                --fd-clr-sd-1: ' . esc_attr($third_color) . '
            }            
        ';
    }


    wp_add_inline_style('fladient-theme-custom-style', $css_output);

}
add_action('wp_enqueue_scripts', 'fladient_theme_options_style');
