<?php


/**
 * Preloader
 *
 * @return  [type]  [return description]
 */
function fladient_preloader(){
    $preloader_enable = cs_get_option('preloader_enable');
    $fladient_custom_preloader = cs_get_option('fladient_custom_preloader');

    if ($preloader_enable == true):
        ?>
        <div id="preloader">
            <div class="preloader-wrap">
                <div class="loading">
                    <div class="icon-ani">
                        <img  src="<?php
                        if (!empty($fladient_custom_preloader['url'])) {
                            echo esc_url($fladient_custom_preloader['url']);
                        }
                        ?>" alt="<?php if(!empty($fladient_custom_preloader['alt'])){ echo esc_attr($fladient_custom_preloader['alt']);}else{ esc_attr_e('Preloader', 'fladient');}?>">
                    </div>
                </div>
            </div>
        </div>
        <?php
    endif;
}

function fladient_scroll_up_btn(){
    $scroll_up_btn = cs_get_option('scroll_up_btn');

    if ($scroll_up_btn == true):
        ?>
        <div class="scroll-top">
            <div class="scroll-top-wrap">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="injected-svg" data-src="https://static.elfsight.com/icons/app-back-to-top-arrow-3.svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="m7.997 10 3.515-3.79a.672.672 0 0 1 .89-.076l.086.075L16 10l-3 .001V18h-2v-7.999L7.997 10z"></path></svg>
            </div>
        </div>
        <?php
    endif;
}

/**
 * fladient Post Loop
 *
 * @return  [type]  [return description]
 */
function fladient_post_loop(){
    if (have_posts()):

        /* Start the Loop */
        while (have_posts()):
            the_post();

            /*
             * Include the Post-Type-specific template for the content.
             * If you want to override this in a child theme, then include a file
             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
             */
            get_template_part('template-parts/content', get_post_type());

        endwhile; ?>
        <!-- pagination -->
        <div class="next-prev-btn pt-20 wow fadeInUp">
            <?php
            fladient_pagination(
                '
                    <i class="fa-solid fa-angles-left feh-pagination-icon"></i>',
                '<i class="fa-solid fa-angles-right feh-pagination-icon"></i>',
                '',
                ['class' => '']
            );
            ?>
        </div>



    <?php else:

        get_template_part('template-parts/content', 'none');

    endif;
}

/**
 * Single Post Loop
 *
 * @return  [type]  [return description]
 */
function fladient_single_post_loop(){
    while (have_posts()):
        the_post();

        get_template_part('template-parts/content', 'single');
    endwhile; // End of the loop.
}

/**
 * Archive Loop
 *
 * @return  [type]  [return description]
 */
function fladient_post_archive_loop(){
    if (have_posts()):
        /* Start the Loop */
        while (have_posts()):
            the_post();

            /*
             * Include the Post-Type-specific template for the content.
             * If you want to override this in a child theme, then include a file
             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
             */
            get_template_part('template-parts/content', get_post_type());

        endwhile; ?>

        <div class="next-prev-btn pt-20 wow fadeInUp">
        <?php
            fladient_pagination(
                '
                    <i class="fa-solid fa-angles-left feh-pagination-icon"></i>',
                '<i class="fa-solid fa-angles-right feh-pagination-icon"></i>',
                '',
                ['class' => '']
            );
            ?>
        </div>

    <?php else:

        get_template_part('template-parts/content', 'none');

    endif;
}

/**
 * Search Loop
 *
 * @return  [type]  [return description]
 */
function fladient_search_loop(){
    if (have_posts()):

        /* Start the Loop */
        while (have_posts()):
            the_post();

            /**
             * Run the loop for the search to output the results.
             * If you want to overload this in a child theme then include a file
             * called content-search.php and that will be used instead.
             */
            get_template_part('template-parts/content', 'search');

        endwhile; ?>
        <div class="next-prev-btn pt-20 wow fadeInUp">
            <?php
            fladient_pagination(
                '
                    <i class="fa-solid fa-angles-left feh-pagination-icon"></i>',
                '<i class="fa-solid fa-angles-right feh-pagination-icon"></i>',
                '',
                ['class' => '']
            );
            ?>
        </div>

    <?php else:

        get_template_part('template-parts/content', 'none');

    endif;
}

/**
 * Page Loop
 *
 * @return  [type]  [return description]
 */
function fladient_page_loop(){
    while (have_posts()):
        the_post();

        get_template_part('template-parts/content', 'page');

        // If comments are open or we have at least one comment, load up the comment template.
        if (comments_open() || get_comments_number()):
            comments_template();
        endif;

    endwhile; // End of the loop.
}
