<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package fladient
 */
add_filter('wpcf7_form_elements', function ($content) {
	$content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

	return $content;
});
/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function fladient_body_classes($classes){
	// Adds a class of hfeed to non-singular pages.
	if (!is_singular()) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if (!is_active_sidebar('sidebar-1')) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter('body_class', 'fladient_body_classes');

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function fladient_pingback_header()
{
	if (is_singular() && pings_open()) {
		printf('<link rel="pingback" href="%s">', esc_url(get_bloginfo('pingback_url')));
	}
}
add_action('wp_head', 'fladient_pingback_header');


/**
 * Breadcrumb
 *
 * @return  [type]  [return description]
 */
function fladient_the_breadcrumb()
{
	global $wp_query;
	$queried_object = get_queried_object();
	$breadcrumb = '';
	$delimiter = '';
	$before = '<li class="breadcrumb-item">';
	$after = '</li>';
	if (!is_front_page()) {
		$breadcrumb .= $before . '<a href="' . home_url('/') . '">' . esc_html__('Home', 'fladient') . ' &nbsp;</a>' . $after;
		/** If category or single post */
		if (is_category()) {
			$cat_obj = $wp_query->get_queried_object();
			$this_category = get_category($cat_obj->term_id);
			if ($this_category->parent != 0) {
				$parent_category = get_category($this_category->parent);
				$breadcrumb .= get_category_parents($parent_category, true, $delimiter);
			}
			$breadcrumb .= $before . '<a href="' . get_category_link(get_query_var('cat')) . '">' . single_cat_title('', false) . '</a>' . $after;
		} elseif ($wp_query->is_posts_page) {
			$breadcrumb .= $before . $queried_object->post_title . $after;
		} elseif (is_tax()) {
			$breadcrumb .= $before . '<a href="' . get_term_link($queried_object) . '">' . $queried_object->name . '</a>' . $after;
		} elseif (is_page()) /** If WP pages */{
			global $post;
			if ($post->post_parent) {
				$anc = get_post_ancestors($post->ID);
				foreach ($anc as $ancestor) {
					$breadcrumb .= $before . '<a href="' . get_permalink($ancestor) . '">' . get_the_title($ancestor) . ' &nbsp;</a>' . $after;
				}
				$breadcrumb .= $before . '' . get_the_title($post->ID) . '' . $after;
			} else {
				$breadcrumb .= $before . '' . get_the_title() . '' . $after;
			}
		} elseif (is_singular()) {
			if ($category = wp_get_object_terms(get_the_ID(), array('category', 'location', 'tax_feature'))) {
				if (!is_wp_error($category)) {
					$breadcrumb .= $before . '<a href="' . get_term_link(fladient_set($category, '0')) . '">' . fladient_set(fladient_set($category, '0'), 'name') . '&nbsp;</a>' . $after;
					$breadcrumb .= $before . '' . get_the_title() . '' . $after;
				} else {
					$breadcrumb .= $before . '' . get_the_title() . '' . $after;
				}
			} else {
				$breadcrumb .= $before . '' . get_the_title() . '' . $after;
			}
		} elseif (is_tag()) {
			$breadcrumb .= $before . '<a href="' . get_term_link($queried_object) . '">' . single_tag_title('', false) . '</a>' . $after;
		} /**If tag template*/elseif (is_day()) {
			$breadcrumb .= $before . '<a href="#">' . esc_html__('Archive for ', 'fladient') . get_the_time('F jS, Y') . '</a>' . $after;
		} /** If daily Archives */elseif (is_month()) {
			$breadcrumb .= $before . '<a href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . __('Archive for ', 'fladient') . get_the_time('F, Y') . '</a>' . $after;
		} /** If montly Archives */elseif (is_year()) {
			$breadcrumb .= $before . '<a href="' . get_year_link(get_the_time('Y')) . '">' . __('Archive for ', 'fladient') . get_the_time('Y') . '</a>' . $after;
		} /** If year Archives */elseif (is_author()) {
			$breadcrumb .= $before . '<a href="' . esc_url(get_author_posts_url(get_the_author_meta("ID"))) . '">' . __('Archive for ', 'fladient') . get_the_author() . '</a>' . $after;
		} /** If author Archives */elseif (is_search()) {
			$breadcrumb .= $before . '' . esc_html__('Search Results for ', 'fladient') . get_search_query() . '' . $after;
		} /** if search template */elseif (is_404()) {
			$breadcrumb .= $before . '' . esc_html__('404 - Not Found', 'fladient') . '' . $after;
			/** if search template */
		} elseif (is_post_type_archive('product')) {
			$shop_page_id = wc_get_page_id('shop');
			if (get_option('page_on_front') !== $shop_page_id) {
				$shop_page = get_post($shop_page_id);
				$_name = wc_get_page_id('shop') ? get_the_title(wc_get_page_id('shop')) : '';
				if (!$_name) {
					$product_post_type = get_post_type_object('product');
					$_name = $product_post_type->labels->singular_name;
				}
				if (is_search()) {
					$breadcrumb .= $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $delimiter . esc_html__('Search results for &ldquo;', 'fladient') . get_search_query() . '&rdquo;' . $after;
				} elseif (is_paged()) {
					$breadcrumb .= $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $after;
				} else {
					$breadcrumb .= $before . $_name . $after;
				}
			}
		} else {
			$breadcrumb .= $before . '<a href="' . get_permalink() . '">' . wp_title() . '</a>' . $after;
		}
		/** Default value */
	}

	return $breadcrumb;
}



function fladient_category_html( $links ) {
    // Use a regular expression to match and replace the default list item structure
    $links = preg_replace_callback(
        '/<a href="([^"]+)"[^>]*>([^<]+)<\/a> \((\d+)\)/',
        function ($matches) {
            $category_link = $matches[1];
            $category_name = $matches[2];
            $category_count = $matches[3];
            
            return '<a class="fd-sidebar-categories-item fd-heading-1" href="' . esc_url($category_link) . '" aria-label="' . esc_attr($category_name) . '" class="fd-sidebar-categories-item fd-heading-1">
                        <span class="icon"></span>
                        <span class="text">' . esc_html($category_name) . '</span>
                        <span class="line"></span>
                        <span class="number">' . esc_html($category_count) . '</span>
                    </a>';
        },
        $links
    );
    
    return $links;
}
add_filter( 'wp_list_categories', 'fladient_category_html' );




function fladient_archive_html($links){
	$links = str_replace('</a>&nbsp;(', '<span class="number">', $links);
	$links = str_replace(')', '</span> <span class="icon-1" >
	<i class="flaticon-left-arrow"></i>
</span></a>', $links);
	return $links;
}

add_filter('get_archives_link', 'fladient_archive_html');


/**
 * Comment Link Class
 *
 * @param [type] $class
 * @return void
 */
function wpdocs_comment_reply_link_class($class)
{
	$class = str_replace("class='comment-reply-link", "class='comment-reply-link reply-btn", $class);
	return $class;
}

add_filter('comment_reply_link', 'wpdocs_comment_reply_link_class');

/**
 * Comment List Modification
 */

function fladient_comments($comment, $args, $depth)
{
	$GLOBALS['comment'] = $comment; ?>

	<div <?php comment_class('comments-box-single wow fadeInUp'); ?> id="comment-<?php comment_ID() ?>">
		<?php if (get_avatar($comment)) { ?>
			<div class="person-img">
				<?php echo get_avatar($comment, 80); ?>
			</div>
		<?php } ?>
		<div class="comments-box-author-content">
			<div class="heading-wrap">
				<div class="title-wrap">
					<span class="name">
						<?php comment_author_link() ?>
					</span>
					<span class="date">
						<?php echo esc_html(get_the_time(get_option('date_format'))); ?>
					</span>
				</div>
				<?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => wp_kses('Reply', true)))); ?>
			</div>
			<div class="comment-text">
				<?php comment_text(); ?>
			</div>
		</div>
	</div>

	<?php
}


/**
 * Comment Message Box
 */
function fladient_comment_reform($arg)
{

	$arg['title_reply'] = esc_html__('Leave a comment', 'fladient');
	$arg['comment_field'] = '<div class="fd-form-item mesggage"> <label for="message" class="fd-form-label fd-heading-1 fd-font-700 text-uppercase">message</label> <textarea id="comment" class="fd-form-input" name="comment" cols="77" rows="3" placeholder="' . esc_attr__("Comment", "fladient") . '" aria-required="true"></textarea></div>';

	return $arg;

}
add_filter('comment_form_defaults', 'fladient_comment_reform');


/**
 * Comment Form Field
 */
function fladient_modify_comment_form_fields($fields)
{
	$commenter = wp_get_current_commenter();
	$req = get_option('require_name_email');

	$fields['author'] = '<div class="fd-form"><div class="fd-form-item"><label for="fname" class="fd-form-label fd-heading-1 fd-font-700 text-uppercase">' . esc_attr__("first name", "fladient") . '</label><input class="fd-form-input" type="text" name="author" id="author" value="' . esc_attr($commenter['comment_author']) . '" placeholder="' . esc_attr__("Name", "fladient") . '" size="22" tabindex="1"' . ($req ? 'aria-required="true"' : '') . ' class="form_control" /></div>';

	$fields['email'] = '<div class="fd-form-item"><label for="fname" class="fd-form-label fd-heading-1 fd-font-700 text-uppercase">' . esc_attr__("Email", "fladient") . '</label><input class="fd-form-input" type="email" name="email" id="email" value="' . esc_attr($commenter['comment_author_email']) . '" placeholder="' . esc_attr__("Email", "fladient") . '" size="22" tabindex="2"' . ($req ? 'aria-required="true"' : '') . ' class="form_control"  /></div>';

	$fields['url'] = '<div class="fd-form-item url"><label for="fname" class="fd-form-label fd-heading-1 fd-font-700 text-uppercase">' . esc_attr__("Website URL", "fladient") . '</label><input class="fd-form-input" type="url" name="url" id="url" value="' . esc_attr($commenter['comment_author_url']) . '" placeholder="' . esc_attr__("Website", "fladient") . '" size="22" tabindex="2"' . ($req ? 'aria-required="false"' : '') . ' class="form_control"  /></div></div>';

	return $fields;
}
add_filter('comment_form_default_fields', 'fladient_modify_comment_form_fields');

// comment Move Field
function fladient_move_comment_field_to_bottom($fields)
{
	$comment_field = $fields['comment'];
	unset($fields['comment']);
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter('comment_form_fields', 'fladient_move_comment_field_to_bottom');



/**
 * Product Per Page Count
 *
 * @param [type] $per_page
 * @return void
 */


/**
 * Authore Avater
 */
function fladient_main_author_avatars($size){
	echo get_avatar(get_the_author_meta('email'), $size);
}

add_action('genesis_entry_header', 'fladient_post_author_avatars');




/**
 * pagination
 */
if (!function_exists('fladient_pagination')) {

	function _fladient_pagi_callback($pagination)
	{
		return $pagination;
	}

	//page navegation
	function fladient_pagination($prev, $next, $pages, $args)
	{
		global $wp_query, $wp_rewrite;
		$menu = '';
		$wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

		if ($pages == '') {
			global $wp_query;
			$pages = $wp_query->max_num_pages;

			if (!$pages) {
				$pages = 1;
			}

		}

		$pagination = [
			'base' => add_query_arg('paged', '%#%'),
			'format' => '',
			'total' => $pages,
			'current' => $current,
			'prev_text' => $prev,
			'next_text' => $next,
			'type' => 'array',
		];

		//rewrite permalinks
		if ($wp_rewrite->using_permalinks()) {
			$pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');
		}

		if (!empty($wp_query->query_vars['s'])) {
			$pagination['add_args'] = ['s' => get_query_var('s')];
		}

		$pagi = '';
		if (paginate_links($pagination) != '') {
			$paginations = paginate_links($pagination);
			$pagi .= '<div class="fd-page-pagination d-inline-flex flex-wrap">';
			foreach ($paginations as $key => $pg) {
				$pagi .= '<li class="fd-page-pagination-btn">' . $pg . '</li>';
			}
			$pagi .= '</div>';
		}

		print _fladient_pagi_callback($pagi);
	}
}


/**
 * Search Widget
 */
function fladient_search_widgets($form)
{
	$form = '<form role="search" method="get" id="searchform" class="fd-search-widget p-relative" action="' . home_url('/') . '" >
    	<input class="fd-search-widget-input" placeholder="' . esc_attr__('Search...', 'fladient') . '" type="text"  value="' . get_search_query() . '" name="s" id="s" />
		<button type="submit" class="fd-search-widget-btn"><i class="fal fa-search"></i></button>
    </form>';
	return $form;
}
add_filter('get_search_form', 'fladient_search_widgets', 100);


/**
 * Authore
 */
function fladient_authore_info()
{

	global $post;
	if (is_object($post)):

		$theme_author_markup = '';
		// Get author's display name
		$display_name = get_the_author_meta('display_name', $post->post_author);

		// If display name is not available then use nickname as display name
		if (empty($display_name))
			$display_name = get_the_author_meta('nickname', $post->post_author);

		// Get author's biographical information or description
		$user_description = get_the_author_meta('user_description', $post->post_author);

		$user_facebook = get_the_author_meta('facebook', $post->post_author);
		$user_twitter = get_the_author_meta('twitter', $post->post_author);
		$user_linkedin = get_the_author_meta('linkedin', $post->post_author);
		$user_instagram = get_the_author_meta('instagram', $post->post_author);
		$user_pinterest = get_the_author_meta('pinterest', $post->post_author);
		$user_youtube = get_the_author_meta('youtube', $post->post_author);

		// Get link to the author archive page
		$user_posts = get_author_posts_url(get_the_author_meta('ID', $post->post_author));
		if (!empty($display_name))
			// Author avatar - - the number 90 is the px size of the image.
			$theme_author_markup .= '<div class="img-wrap">' . get_avatar(get_the_author_meta('ID'), 140) . '</div>';
		$theme_author_markup .= '<div class="inner-text headline pera-content">';
		$theme_author_markup .= '<span class="name fd-heading-1 fd-font-800">' . $display_name . '</span>';
		$theme_author_markup .= '<p class="comment-text fd-para-1 has-para-sm">' . get_the_author_meta('description') . '</p>';
		$theme_author_markup .= '<ul class="social-link">';


		// Check if author has Twitter in their profile

		if (!empty($user_facebook)) {
			$theme_author_markup .= ' <li><a href="' . $user_facebook . '" target="_blank" rel="nofollow" class="fb_aut" title="Facebook"><i class="fab fa-facebook-f"></i> </a></li>';
		}


		if (!empty($user_twitter)) {
			$theme_author_markup .= '<li> <a href="' . $user_twitter . '" target="_blank" rel="nofollow" class="twi_aut" title="Twitter"><i class="fab fa-twitter"></i> </a></li>';
		}

		if (!empty($user_instagram)) {
			$theme_author_markup .= '<li> <a href="' . $user_instagram . '" target="_blank" rel="nofollow" class="inst_aut" title="Instagram"><i class="fab fa-instagram"></i> </a></li>';
		}

		if (!empty($user_pinterest)) {
			$theme_author_markup .= '<li> <a href="' . $user_pinterest . '" target="_blank" rel="nofollow" class="pint_aut" title="Pinterest"><i class="fab fa-pinterest-p"></i> </a></li>';
		}

		if (!empty($user_youtube)) {
			$theme_author_markup .= '<li> <a href="' . $user_youtube . '" target="_blank" rel="nofollow" class="you_aut" title="Youtube"><i class="fab fa-youtube"></i> </a>';
		}

		if (!empty($user_linkedin)) {
			$theme_author_markup .= '<li> <a href="' . $user_linkedin . '" target="_blank" rel="nofollow" class="link_aut" title="linkedin"><i class="fab fa-linkedin-in"></i> </a></li>';
		}

		$theme_author_markup .= '</ul>';
		$theme_author_markup .= '</div>';

		// Pass all this info to post content 
		echo '<div class="fd-blog-comment-item mb-30">' . $theme_author_markup . '</div>';
	endif;
}

function fladient_wp_kses( $val ) {
    return wp_kses( $val, array(

        'p'      => array(
            'class' => array(),
            'style' => array(),
        ),

        'img'    => array(
            'src'   => array(),
            'alt'   => array(),
            'class' => array(),
            'style' => array(),
        ),
        'span'   => array(
            'class' => array(),
            'style' => array(),
        ),
        'small'  => array(),
        'div'    => array(
            'style' => array(),
        ),
        'strong' => array(
            'style' => array(),
        ),
        'b'      => array(
            'style' => array(),
        ),
        'br'     => array(),
        'h1'     => array(
            'style' => array(),
        ),
        'i'      => array(
            'class' => array(),
            'style' => array(),
        ),
        'ul'     => array(
            'class' => array(),
            'style' => array(),
        ),
        'ul'     => array(
            'id' => array(),
        ),
        'li'     => array(
            'class' => array(),
            'style' => array(),
        ),
        'li'     => array(
            'id' => array(),
        ),
        'h1'     => array(
            'style' => array(),
        ),
        'h2'     => array(),
        'h3'     => array(
            'style' => array(),
        ),
        'h4'     => array(
            'style' => array(),
        ),
        'h5'     => array(
            'style' => array(),
        ),
        'h6'     => array(
            'style' => array(),
        ),
        'a'      => array( 
            'href' => array(), 
            'target' => array(),
            'style' => array(),
        ),
        'iframe' => array( 'src' => array(), 'height' => array(), 'width' => array() ),

    ), '' );
}


/**
 * Product Per Page Count
 *
 * @param [type] $per_page
 * @return void
 */ 

 function fladient_product_count( $cols ) {
	$product_count = cs_get_option('product_count');
  	$cols = !empty($product_count) ? $product_count : '12';
  	return $cols;
}
add_filter( 'loop_shop_per_page', 'fladient_product_count', 20 );