<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package fladient
 */
$categories = get_the_category();
$blog_btn_text = cs_get_option('blog_btn_text');
$hide_blog_date = cs_get_option('hide_blog_date');
$hide_authore = cs_get_option('hide_authore');
$hide_cmt_date = cs_get_option('hide_cmt_date');
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('fd-blog-6-item'); ?>>
	<?php if (has_post_thumbnail()) { ?>
		<div class="item-img fix img-cover">
			<?php the_post_thumbnail('full') ?>
		</div>
	<?php } ?>
	<div class="fd-blog-6-item-meta">
		<span class="item-meta-item fd-para-1 has-para-sm text-capitalize">
			<i class="flaticon-user flaticon"></i>
			<?php the_author();?>
		</span>
		<span class="item-meta-item fd-para-1 has-para-sm text-capitalize">
			<i class="flaticon-chat-1 flaticon"></i>
			<?php esc_html_e('comments', 'fladient'); ?>(<?php echo esc_attr(get_comments_number()); ?>)
		</span>
		<span class="item-meta-item fd-para-1 has-para-sm text-capitalize">
			<i class="flaticon-calendar flaticon"></i>
			<?php echo date(get_option('date_format')); ?>
		</span>
	</div>
	<div class="item-content text-center">
		<h4 class="fd-heading-1 fd-font-900 item-title">
			<a href="<?php the_permalink() ?>">
				<?php the_title(); ?>
			</a>
		</h4>

		<div class="fd-para-1 item-disc"><?php the_excerpt(); ?></div>

		<a href="<?php the_permalink() ?>" aria-label="name" class="item-btn text-uppercase fd-heading-1 fd-font-500">
			
			<?php if (!empty($blog_btn_text)) {
				echo esc_html($blog_btn_text);
			} else {
				esc_html_e('read more', 'fladient');
			} ?>
			<span  ><i class="flaticon-thin-arrow flaticon"></i></span>
		</a>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->