<?php
/**
 * Template part for displaying single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package fladient
 */
$categories = get_the_category();
?>
<div id="post-<?php the_ID(); ?>" <?php post_class('fd-blog-single-wrap'); ?>>
    <div class="fd-blog-single-img fix img-cover">
        <?php if (has_post_thumbnail()) { ?>
            <?php the_post_thumbnail('full') ?>
        <?php } ?>
    </div>
    <div class="fd-blog-single-content-width">
        <div class="fd-blog-single-content">
            <div class="fd-blog-6-item-meta">
                <span class="item-meta-item fd-para-1 has-para-sm text-capitalize">
                    <i class="flaticon-user flaticon"></i>
                    <?php the_author();?>
                </span>
                <span class="item-meta-item fd-para-1 has-para-sm text-capitalize">
                    <i class="flaticon-chat-1 flaticon"></i>
                    <?php esc_html_e('comments', 'fladient'); ?>(<?php echo esc_attr(get_comments_number()); ?>)
                </span>
                <span class="item-meta-item fd-para-1 has-para-sm text-capitalize">
                    <i class="flaticon-calendar flaticon"></i>
                    <?php echo date(get_option('date_format')); ?>
                </span>
            </div>

            <h1><?php the_title(); ?></h1>
            
            <?php
                the_content(
                    sprintf(
                        wp_kses(
                            /* translators: %s: Name of current post. Only visible to screen readers */
                            __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'fladient'),
                            array(
                                'span' => array(
                                    'class' => array(),
                                ),
                            )
                        ),
                        wp_kses_post(get_the_title())
                    )
                );

                wp_link_pages(
                    array(
                        'before' => '<div class="page-links">' . esc_html__('Pages:', 'fladient'),
                        'after' => '</div>',
                    )
                );
            ?>

        </div>
        
        <div class="fd-blog-tag-share mt-40 mb-30">

            <?php if (function_exists('fladient_entry_footer')): ?>
                <div class="fd-blog-tag fd-heading-1">
                    <h6 class="title fd-heading-1 fd-font-700"><?php esc_html_e('Tags:', 'fladient');?></h6>
                    <?php fladient_entry_footer();?>
                </div>
            <?php endif;?>

            <?php if (function_exists('fladient_post_share')): ?>
            <?php fladient_post_share();?>
            <?php endif;?>
        </div>
        <?php fladient_authore_info();?>

        <div class="fd-form-box">
            <?php if (comments_open() || get_comments_number()):
                comments_template();
            endif;?>
        </div>
        
    </div>
</div>